/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.crypto;

import com.selima.fbi.crypto.Buffer;
import com.selima.fbi.crypto.IBytesTransformation;
import java.io.IOException;

class TransformingBuffer
extends Buffer {
    private IBytesTransformation transformation;

    TransformingBuffer(IBytesTransformation transformation) {
        super(8192);
        this.transformation = transformation;
    }

    public boolean feedFrom(Buffer src) throws IOException {
        return this.feedWhileTransforming(src, false);
    }

    public boolean feedLastBitsFrom(Buffer src) throws IOException {
        return this.feedWhileTransforming(src, true);
    }

    private boolean feedWhileTransforming(Buffer src, boolean lastBits) throws IOException {
        if (this.transformation.getOutputSize(src.canGive()) <= this.canFeed()) {
            this.toFillingMode();
            src.toEmptyingMode();
            if (lastBits) {
                this.transformation.transformLastBytes(src.bytes, this.bytes);
            } else {
                this.transformation.transform(src.bytes, this.bytes);
            }
            return true;
        }
        return false;
    }
}

