/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class Buffer {
    ByteBuffer bytes;
    boolean fillingMode;

    Buffer() {
        this(4096);
    }

    Buffer(int size) {
        this.bytes = ByteBuffer.allocate(size);
        this.bytes.limit(0);
    }

    public int giveByte() {
        this.toEmptyingMode();
        return this.bytes.get() & 0xFF;
    }

    public void feedByte(int b) {
        this.toFillingMode();
        this.bytes.put((byte)b);
    }

    public boolean feedFrom(InputStream stream) throws IOException {
        this.toFillingMode();
        int cnt = stream.read(this.bytes.array(), this.bytes.position(), this.bytes.capacity());
        if (cnt >= 0) {
            this.bytes.position(this.bytes.position() + cnt);
            return false;
        }
        return true;
    }

    public void giveTo(OutputStream stream) throws IOException {
        this.toEmptyingMode();
        stream.write(this.bytes.array(), this.bytes.position(), this.bytes.remaining());
        this.bytes.position(this.bytes.position() + this.bytes.remaining());
    }

    public void giveTo(ByteBuffer output) {
        this.toEmptyingMode();
        int num = Math.min(output.remaining(), this.bytes.remaining());
        output.put(this.bytes.array(), this.bytes.position(), num);
        this.bytes.position(this.bytes.position() + num);
    }

    public void feedFrom(ByteBuffer input) {
        this.toFillingMode();
        int num = Math.min(input.remaining(), this.bytes.remaining());
        this.bytes.put(input.array(), input.position(), num);
        input.position(input.position() + num);
    }

    public int skip(int ammount) {
        this.toEmptyingMode();
        int num = Math.min(ammount, this.bytes.remaining());
        this.bytes.position(this.bytes.position() + num);
        return num;
    }

    public int canGive() {
        this.toEmptyingMode();
        return this.bytes.remaining();
    }

    public int canFeed() {
        this.toFillingMode();
        return this.bytes.remaining();
    }

    protected void toEmptyingMode() {
        if (this.fillingMode) {
            this.fillingMode = false;
            this.bytes.flip();
        }
    }

    protected void toFillingMode() {
        if (!this.fillingMode) {
            this.fillingMode = true;
            this.bytes.compact();
        }
    }

    public String toString() {
        boolean oldMode = this.fillingMode;
        try {
            String string = "Buffer[r:" + this.canGive() + ",w:" + this.canFeed() + "]";
            return string;
        }
        finally {
            if (oldMode) {
                this.toFillingMode();
            } else {
                this.toEmptyingMode();
            }
        }
    }
}

