/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.wnu2006;

import com.selima.fbi.FormType;
import com.selima.fbi.core.Agent;
import com.selima.fbi.core.Contact;
import com.selima.fbi.core.IWnuMessage;
import com.selima.fbi.core.standard.AbstractPAYEMessage;
import com.selima.fbi.core.standard.generated.wnu2006.IRenvelope;
import com.selima.fbi.core.standard.generated.wnu2006.IRheader;
import java.util.Map;

public class Wnu2006Message
extends AbstractPAYEMessage<IRenvelope>
implements IWnuMessage {
    private int recordCount;

    public Wnu2006Message(IRenvelope envelope, byte[] bytes) {
        super(envelope, "http://www.govtalk.gov.uk/taxation/WNU", bytes);
        this.recordCount = this.mapRecordCount(envelope);
    }

    private int mapRecordCount(IRenvelope envelope) {
        return envelope.getWorksNumberUpdate().getRecordCount();
    }

    @Override
    protected void getKeys(IRenvelope envelope, Map<String, String> keyMap) {
        for (IRheader.Keys.Key key : envelope.getIRheader().getKeys().getKeies()) {
            keyMap.put(key.getType(), key.getValue());
        }
    }

    @Override
    protected Agent mapAgent(IRenvelope envelope) {
        if (envelope.getIRheader().getAgent() != null) {
            return new Agent(envelope.getIRheader().getAgent());
        }
        return null;
    }

    @Override
    protected Contact mapPrincipal(IRenvelope envelope) {
        if (envelope.getIRheader().getPrincipal() != null) {
            return new Contact(envelope.getIRheader().getPrincipal().getContact());
        }
        return null;
    }

    @Override
    protected String mapSender(IRenvelope envelope) {
        return envelope.getIRheader().getSender();
    }

    @Override
    protected boolean mapTestMessage(IRenvelope envelope) {
        return Integer.valueOf(1).equals(envelope.getIRheader().getTestMessage());
    }

    @Override
    protected FormType mapFormType(IRenvelope envelope) {
        return FormType.WNU;
    }

    @Override
    protected String mapSubject(IRenvelope envelope) {
        return null;
    }

    @Override
    protected int mapTaxYearEnd(IRenvelope envelope) {
        return envelope.getIRheader().getPeriodEnd().getYear();
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }
}

