/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.rti2017;

import com.selima.fbi.FormType;
import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.core.Agent;
import com.selima.fbi.core.Contact;
import com.selima.fbi.core.IEPSMessage;
import com.selima.fbi.core.standard.AbstractPAYEMessage;
import com.selima.fbi.core.standard.generated.eps2017.IRenvelope;
import com.selima.fbi.core.standard.generated.eps2017.IRheader;
import java.util.Map;

public class EPSMessage2017
extends AbstractPAYEMessage<IRenvelope>
implements IEPSMessage {
    public EPSMessage2017(IRenvelope envelope, byte[] bytes) {
        super(envelope, "http://www.govtalk.gov.uk/taxation/PAYE/RTI/EmployerPaymentSummary/16-17/1", bytes);
    }

    @Override
    protected FormType mapFormType(IRenvelope parsedMessage) {
        return FormType.EPS;
    }

    @Override
    protected void getKeys(IRenvelope envelope, Map<String, String> keyMap) {
        for (IRheader.Keys.Key key : envelope.getIRheader().getKeys().getKeies()) {
            keyMap.put(key.getType(), key.getValue());
        }
    }

    @Override
    protected boolean mapTestMessage(IRenvelope envelope) {
        return MailServiceConfig.isDevelopmentVersion();
    }

    @Override
    protected Contact mapPrincipal(IRenvelope envelope) {
        if (envelope.getIRheader().getPrincipal() != null) {
            return new Contact(envelope.getIRheader().getPrincipal().getContact());
        }
        return null;
    }

    @Override
    protected String mapSender(IRenvelope envelope) {
        return envelope.getIRheader().getSender();
    }

    @Override
    protected Agent mapAgent(IRenvelope envelope) {
        if (envelope.getIRheader().getAgent() != null) {
            return new Agent(envelope.getIRheader().getAgent());
        }
        return null;
    }

    @Override
    protected int mapTaxYearEnd(IRenvelope envelope) {
        return envelope.getIRheader().getPeriodEnd().getYear();
    }

    @Override
    protected final String mapSubject(IRenvelope envelope) {
        return null;
    }
}

