/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.mov2010;

import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.core.Agent;
import com.selima.fbi.core.Contact;
import com.selima.fbi.core.IMovMessage;
import com.selima.fbi.core.standard.AbstractPAYEMessage;
import com.selima.fbi.core.standard.generated.mov2010.IRenvelope;
import com.selima.fbi.core.standard.generated.mov2010.IRheader;
import java.util.Map;

abstract class AbstractMov2010Message
extends AbstractPAYEMessage<IRenvelope>
implements IMovMessage {
    int p45Part1Count;
    int p45Part3Count;
    int p46Count;
    int PENNOTCount;

    AbstractMov2010Message(IRenvelope envelope, byte[] bytes) {
        super(envelope, "http://www.govtalk.gov.uk/taxation/PAYE/MOV/09-10/1", bytes);
        this.PENNOTCount = this.mapPENNOTCount(envelope);
        this.p45Part1Count = this.mapP45Part1Count(envelope);
        this.p45Part3Count = this.mapP45Part3Count(envelope);
        this.p46Count = this.mapP46Count(envelope);
    }

    private int mapPENNOTCount(IRenvelope envelope) {
        return envelope.getInYearMovements().getPensionNotifications().size();
    }

    private int mapP46Count(IRenvelope envelope) {
        return envelope.getInYearMovements().getP46S().size();
    }

    private int mapP45Part3Count(IRenvelope envelope) {
        return envelope.getInYearMovements().getP45Part3s().size();
    }

    private int mapP45Part1Count(IRenvelope envelope) {
        return envelope.getInYearMovements().getP45Part1s().size();
    }

    @Override
    protected void getKeys(IRenvelope envelope, Map<String, String> keyMap) {
        for (IRheader.Keys.Key key : envelope.getIRheader().getKeys().getKeies()) {
            keyMap.put(key.getType(), key.getValue());
        }
    }

    @Override
    protected Agent mapAgent(IRenvelope envelope) {
        if (envelope.getIRheader().getAgent() != null) {
            return new Agent(envelope.getIRheader().getAgent());
        }
        return null;
    }

    @Override
    protected Contact mapPrincipal(IRenvelope envelope) {
        if (envelope.getIRheader().getPrincipal() != null) {
            return new Contact(envelope.getIRheader().getPrincipal().getContact());
        }
        return null;
    }

    @Override
    protected String mapSender(IRenvelope envelope) {
        return envelope.getIRheader().getSender();
    }

    @Override
    protected boolean mapTestMessage(IRenvelope envelope) {
        return MailServiceConfig.isDevelopmentVersion();
    }

    @Override
    protected String mapSubject(IRenvelope parsedMessage) {
        return null;
    }

    @Override
    protected int mapTaxYearEnd(IRenvelope parsedMessage) {
        return parsedMessage.getIRheader().getPeriodEnd().getYear();
    }

    @Override
    public int getCount() {
        return this.p45Part1Count + this.p45Part3Count + this.p46Count + this.PENNOTCount;
    }
}

