/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.eoy2013;

import com.selima.fbi.core.Agent;
import com.selima.fbi.core.Contact;
import com.selima.fbi.core.common_eoy_2012_2013.IP14PartMessage2012_and_2013;
import com.selima.fbi.core.standard.AbstractP14PartMessage;
import com.selima.fbi.core.standard.eoy2013.Tools;
import com.selima.fbi.core.standard.generated.paye2013.IRenvelope;
import com.selima.fbi.core.standard.generated.paye2013.IRheader;
import java.util.Map;

public class P14Part2013Message
extends AbstractP14PartMessage<IRenvelope>
implements IP14PartMessage2012_and_2013 {
    private final Number totalASPP;

    public P14Part2013Message(IRenvelope envelope, byte[] bytes) {
        super(envelope, "http://www.govtalk.gov.uk/taxation/EOY/" + Tools.taxYearString(envelope) + "/1", bytes);
        this.totalASPP = this.mapTotalASPP(envelope);
    }

    @Override
    public Number getTotalASPP() {
        return this.totalASPP;
    }

    protected Number mapTotalASPP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalASPP().getValue();
    }

    @Override
    protected String mapUniqueID(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getUniqueID();
    }

    @Override
    protected void getKeys(IRenvelope envelope, Map<String, String> keyMap) {
        for (IRheader.Keys.Key key : envelope.getIRheader().getKeys().getKeies()) {
            keyMap.put(key.getType(), key.getValue());
        }
    }

    @Override
    protected int mapTaxYearEnd(IRenvelope envelope) {
        return envelope.getIRheader().getPeriodEnd().getYear();
    }

    @Override
    protected int mapP14Count(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getP14Count();
    }

    @Override
    protected Number mapTotalContributions(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalContributions().getValue();
    }

    @Override
    protected Number mapTotalStudentLoanDeductions(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalStudentLoanDeductions().getValue();
    }

    @Override
    protected Number mapTotalSAP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalSAP().getValue();
    }

    @Override
    protected Number mapTotalSMP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalSMP().getValue();
    }

    @Override
    protected Number mapTotalSPP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalOSPP().getValue();
    }

    @Override
    protected Number mapTotalSSP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalSSP().getValue();
    }

    @Override
    protected Number mapTotalTax(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalTax().getValue();
    }

    @Override
    protected Agent mapAgent(IRenvelope envelope) {
        if (envelope.getIRheader().getAgent() != null) {
            return new Agent(envelope.getIRheader().getAgent());
        }
        return null;
    }

    @Override
    protected Contact mapPrincipal(IRenvelope envelope) {
        if (envelope.getIRheader().getPrincipal() != null) {
            return new Contact(envelope.getIRheader().getPrincipal().getContact());
        }
        return null;
    }

    @Override
    protected String mapSender(IRenvelope envelope) {
        return envelope.getIRheader().getSender();
    }

    @Override
    protected boolean mapTestMessage(IRenvelope envelope) {
        return Integer.valueOf(1).equals(envelope.getIRheader().getTestMessage());
    }
}

