/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.eoy2010;

import com.selima.fbi.core.Agent;
import com.selima.fbi.core.Contact;
import com.selima.fbi.core.standard.AbstractP35PartMessage;
import com.selima.fbi.core.standard.generated.paye2010.IRenvelope;
import com.selima.fbi.core.standard.generated.paye2010.IRheader;
import java.util.Date;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;

public class P35Part2010Message
extends AbstractP35PartMessage<IRenvelope> {
    public P35Part2010Message(IRenvelope envelope, byte[] bytes) {
        super(envelope, "http://www.govtalk.gov.uk/taxation/EOY/09-10/1", bytes);
        if (!"P35Part".equals(envelope.getEndOfYearReturn().getSubmissionType())) {
            throw new IllegalArgumentException("Not a P35Part");
        }
    }

    @Override
    protected Date mapCessationDate(IRenvelope envelope) {
        XMLGregorianCalendar cessationDate = envelope.getEndOfYearReturn().getP35().getCessationDate();
        return cessationDate != null ? cessationDate.toGregorianCalendar().getTime() : null;
    }

    @Override
    protected String mapECON(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getEmployerDetails().getECON();
    }

    @Override
    protected String mapEmployerName(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getEmployerDetails().getEmployerName();
    }

    @Override
    protected int mapNumberOfParts(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getNumberOfParts();
    }

    @Override
    protected Number mapSAP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getSAP().getValue();
    }

    @Override
    protected Number mapSMP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getSMP().getValue();
    }

    @Override
    protected Number mapSSP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getSSP().getValue();
    }

    @Override
    protected Number mapSPP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getSPP().getValue();
    }

    @Override
    protected Number mapTotalNIC(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getTotalNIC().getValue();
    }

    @Override
    protected Number mapTotalPayable(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getCombinedAmounts().getTotalPayable().getValue();
    }

    @Override
    protected Number mapTotalRemainingToPay(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getCombinedAmounts().getTotalRemainingToPay().getValue();
    }

    @Override
    protected Number mapTotalTax(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getPAYE().getTotalTax().getValue();
    }

    @Override
    protected void getKeys(IRenvelope envelope, Map<String, String> keyMap) {
        for (IRheader.Keys.Key key : envelope.getIRheader().getKeys().getKeies()) {
            keyMap.put(key.getType(), key.getValue());
        }
    }

    @Override
    protected Agent mapAgent(IRenvelope envelope) {
        if (envelope.getIRheader().getAgent() != null) {
            return new Agent(envelope.getIRheader().getAgent());
        }
        return null;
    }

    @Override
    protected Contact mapPrincipal(IRenvelope envelope) {
        if (envelope.getIRheader().getPrincipal() != null) {
            return new Contact(envelope.getIRheader().getPrincipal().getContact());
        }
        return null;
    }

    @Override
    protected String mapSender(IRenvelope envelope) {
        return envelope.getIRheader().getSender();
    }

    @Override
    protected boolean mapTestMessage(IRenvelope envelope) {
        return Integer.valueOf(1).equals(envelope.getIRheader().getTestMessage());
    }

    @Override
    protected int mapTaxYearEnd(IRenvelope envelope) {
        return envelope.getIRheader().getPeriodEnd().getYear();
    }
}

