/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.eoy2007;

import com.selima.fbi.core.Agent;
import com.selima.fbi.core.Contact;
import com.selima.fbi.core.standard.AbstractEOYMessage;
import com.selima.fbi.core.standard.generated.paye2007.IRenvelope;
import com.selima.fbi.core.standard.generated.paye2007.IRheader;
import java.util.Date;
import java.util.Map;

public class EOY2007Message
extends AbstractEOYMessage<IRenvelope> {
    public EOY2007Message(IRenvelope payeRecord, byte[] bytes) {
        super(payeRecord, "http://www.govtalk.gov.uk/taxation/EOY/06-07/1", bytes);
    }

    @Override
    protected Date mapCessationDate(IRenvelope envelope) {
        if (envelope.getEndOfYearReturn().getP35().getCessationDate() != null) {
            return envelope.getEndOfYearReturn().getP35().getCessationDate().toGregorianCalendar().getTime();
        }
        return null;
    }

    @Override
    protected String mapECON(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getEmployerDetails().getECON();
    }

    @Override
    protected String mapEmployerName(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getEmployerDetails().getEmployerName();
    }

    @Override
    protected int mapP14Count(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP14Count().intValue();
    }

    @Override
    protected Number mapSAP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getSAP().getValue();
    }

    @Override
    protected Number mapSMP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getSMP().getValue();
    }

    @Override
    protected Number mapSPP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getSPP().getValue();
    }

    @Override
    protected Number mapSSP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getSPP().getValue();
    }

    @Override
    protected Number mapTotalNIC(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getNIC().getTotalNIC().getValue();
    }

    @Override
    protected Number mapTotalPayable(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getCombinedAmounts().getTotalPayable().getValue();
    }

    @Override
    protected Number mapTotalRemainingToPay(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getCombinedAmounts().getTotalRemainingToPay().getValue();
    }

    @Override
    protected Number mapTotalTax(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getP35().getSummary().getPAYE().getTotalTax().getValue();
    }

    @Override
    protected void getKeys(IRenvelope envelope, Map<String, String> keyMap) {
        for (IRheader.Keys.Key key : envelope.getIRheader().getKeys().getKeies()) {
            keyMap.put(key.getType(), key.getValue());
        }
    }

    @Override
    protected Agent mapAgent(IRenvelope envelope) {
        if (envelope.getIRheader().getAgent() != null) {
            return new Agent(envelope.getIRheader().getAgent());
        }
        return null;
    }

    @Override
    protected Contact mapPrincipal(IRenvelope envelope) {
        if (envelope.getIRheader().getPrincipal() != null) {
            return new Contact(envelope.getIRheader().getPrincipal().getContact());
        }
        return null;
    }

    @Override
    protected String mapSender(IRenvelope envelope) {
        return envelope.getIRheader().getSender();
    }

    @Override
    protected boolean mapTestMessage(IRenvelope envelope) {
        return Integer.valueOf(1).equals(envelope.getIRheader().getTestMessage());
    }

    @Override
    protected int mapTaxYearEnd(IRenvelope envelope) {
        return envelope.getIRheader().getPeriodEnd().getYear();
    }
}

