/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.eoy2006;

import com.selima.fbi.core.Agent;
import com.selima.fbi.core.Contact;
import com.selima.fbi.core.standard.AbstractP14PartMessage;
import com.selima.fbi.core.standard.generated.paye2006.IRenvelope;
import com.selima.fbi.core.standard.generated.paye2006.IRheader;
import java.util.Map;

public class P14Part2006Message
extends AbstractP14PartMessage<IRenvelope> {
    public P14Part2006Message(IRenvelope envelope, byte[] bytes) {
        super(envelope, "http://www.govtalk.gov.uk/taxation/EOY", bytes);
        if (!"P14Part".equals(envelope.getEndOfYearReturn().getSubmissionType())) {
            throw new IllegalArgumentException("Not a P14Part");
        }
    }

    @Override
    protected String mapUniqueID(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getUniqueID();
    }

    @Override
    protected int mapTaxYearEnd(IRenvelope envelope) {
        return envelope.getIRheader().getPeriodEnd().getYear();
    }

    @Override
    protected void getKeys(IRenvelope envelope, Map<String, String> keyMap) {
        for (IRheader.Keys.Key key : envelope.getIRheader().getKeys().getKeies()) {
            keyMap.put(key.getType(), key.getValue());
        }
    }

    @Override
    protected int mapP14Count(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getP14Count();
    }

    @Override
    protected Number mapTotalContributions(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalContributions().getValue();
    }

    @Override
    protected Number mapTotalStudentLoanDeductions(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalStudentLoanDeductions().getValue();
    }

    @Override
    protected Number mapTotalSAP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalSAP().getValue();
    }

    @Override
    protected Number mapTotalSMP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalSMP().getValue();
    }

    @Override
    protected Number mapTotalSPP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalSPP().getValue();
    }

    @Override
    protected Number mapTotalSSP(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalSPP().getValue();
    }

    @Override
    protected Number mapTotalTax(IRenvelope envelope) {
        return envelope.getEndOfYearReturn().getPartTotals().getTotalTax().getValue();
    }

    @Override
    protected Agent mapAgent(IRenvelope envelope) {
        if (envelope.getIRheader().getAgent() != null) {
            return new Agent(envelope.getIRheader().getAgent());
        }
        return null;
    }

    @Override
    protected Contact mapPrincipal(IRenvelope envelope) {
        if (envelope.getIRheader().getPrincipal() != null) {
            return new Contact(envelope.getIRheader().getPrincipal().getContact());
        }
        return null;
    }

    @Override
    protected String mapSender(IRenvelope envelope) {
        return envelope.getIRheader().getSender();
    }

    @Override
    protected boolean mapTestMessage(IRenvelope envelope) {
        return Integer.valueOf(1).equals(envelope.getIRheader().getTestMessage());
    }
}

