/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.dps;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IRTINotMessage;
import com.selima.fbi.core.standard.AbstractDPSMessage;
import com.selima.fbi.core.standard.generated.rtinot.RTINot;
import java.util.Date;

public class RTINotDPSMessage
extends AbstractDPSMessage<RTINot>
implements IRTINotMessage {
    String correlationID;
    String surname;
    String ninoProvided;
    String payId;
    String ninoToUse;
    String messageId;

    public RTINotDPSMessage(RTINot content, byte[] data) {
        super(content, "http://www.govtalk.gov.uk/taxation/RTInotification/1", data);
        this.correlationID = content.getCorrelationID();
        this.surname = content.getName().getSur();
        this.ninoProvided = content.getNINOProvided();
        this.payId = content.getPayId();
        this.ninoToUse = content.getNINOToUse();
        this.messageId = content.getMessageID().toString();
    }

    @Override
    protected long mapSequenceNumber(RTINot parsedMessage) {
        return parsedMessage.getSequenceNumber();
    }

    @Override
    protected String mapEmpRef(RTINot parsedMessage) {
        return parsedMessage.getEmployerRef();
    }

    @Override
    protected String mapSubject(RTINot parsedMessage) {
        StringBuilder result = new StringBuilder();
        if (parsedMessage.getMessageID() != null) {
            result.append('[').append(parsedMessage.getMessageID()).append("] ");
        }
        if (this.isDefined(parsedMessage.getNINOToUse())) {
            result.append(parsedMessage.getNINOToUse()).append(' ');
        } else if (this.isDefined(parsedMessage.getPayId())) {
            result.append("(").append(parsedMessage.getPayId()).append(") ");
        }
        RTINot.Name employeeName = parsedMessage.getName();
        if (employeeName != null) {
            if (this.isDefined(employeeName.getTtl())) {
                result.append(employeeName.getTtl()).append(' ');
            }
            if (this.isDefined(employeeName.getInitials())) {
                result.append(employeeName.getInitials()).append(' ');
            } else if (employeeName.getFore() != null && !employeeName.getFore().isEmpty()) {
                for (String forename : employeeName.getFore()) {
                    result.append(forename).append(' ');
                }
            }
            result.append(employeeName.getSur());
        }
        return result.toString();
    }

    private boolean isDefined(String str) {
        return str != null && !str.isEmpty();
    }

    @Override
    protected FormType mapFormType(RTINot parsedMessage) {
        switch (parsedMessage.getFormType()) {
            case "NOT": {
                return FormType.NOT;
            }
            case "NVR": {
                return FormType.NVR;
            }
        }
        throw new IllegalArgumentException("Unsupported FormType: " + parsedMessage.getFormType());
    }

    @Override
    protected Date mapIssueDate(RTINot parsedMessage) {
        return parsedMessage.getIssueDate().toGregorianCalendar().getTime();
    }

    @Override
    public String getPayrollWarningMessage() {
        return null;
    }

    @Override
    protected String mapHMRCoffice(RTINot parsedMessage) {
        return null;
    }

    @Override
    protected int mapTaxYearEnd(RTINot parsedMessage) {
        return -1;
    }

    @Override
    public String getCorrelationID() {
        return this.correlationID;
    }

    @Override
    public String getSurname() {
        return this.surname;
    }

    @Override
    public String getNinoProvided() {
        return this.ninoProvided;
    }

    @Override
    public String getPayId() {
        return this.payId;
    }

    @Override
    public String getNinoToUse() {
        return this.ninoToUse;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }
}

