/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.dps;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IPGL1Message;
import com.selima.fbi.core.standard.AbstractDPSMessage;
import com.selima.fbi.core.standard.generated.pgl2.PostgraduateLoanStart;
import java.util.Date;
import java.util.List;

public class PostgraduateLoanStartDPSMessage
extends AbstractDPSMessage<PostgraduateLoanStart>
implements IPGL1Message {
    String nino;
    String worksNumber;
    String surname;
    List<String> forename;
    Date startDate;

    public PostgraduateLoanStartDPSMessage(PostgraduateLoanStart content, byte[] data) {
        super(content, "http://www.govtalk.gov.uk/taxation/PostgraduateLoanStart/1", data);
        this.startDate = content.getLoanStartDate().toGregorianCalendar().getTime();
        this.forename = content.getName().getForename();
        this.worksNumber = content.getWorksNumber();
        this.surname = content.getName().getSurname();
        this.nino = content.getNINO();
    }

    @Override
    protected long mapSequenceNumber(PostgraduateLoanStart parsedMessage) {
        return parsedMessage.getSequenceNumber();
    }

    @Override
    protected String mapEmpRef(PostgraduateLoanStart parsedMessage) {
        return parsedMessage.getEmployerRef();
    }

    @Override
    protected String mapSubject(PostgraduateLoanStart parsedMessage) {
        return this.employee(parsedMessage.getName().getForename(), parsedMessage.getName().getSurname(), parsedMessage.getWorksNumber(), parsedMessage.getNINO());
    }

    @Override
    protected FormType mapFormType(PostgraduateLoanStart parsedMessage) {
        return FormType.PGL1;
    }

    @Override
    protected Date mapIssueDate(PostgraduateLoanStart parsedMessage) {
        return parsedMessage.getIssueDate().toGregorianCalendar().getTime();
    }

    @Override
    protected String mapHMRCoffice(PostgraduateLoanStart parsedMessage) {
        return "";
    }

    @Override
    protected int mapTaxYearEnd(PostgraduateLoanStart parsedMessage) {
        return Integer.parseInt(parsedMessage.getTaxYearEnd());
    }

    @Override
    public String getNino() {
        return this.nino;
    }

    @Override
    public String getWorksNumber() {
        return this.worksNumber;
    }

    @Override
    public String getSurname() {
        return this.surname;
    }

    @Override
    public List<String> getForename() {
        return this.forename;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public String getPayrollWarningMessage() {
        return null;
    }
}

