/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.dps;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IPGL2Message;
import com.selima.fbi.core.standard.AbstractDPSMessage;
import com.selima.fbi.core.standard.generated.pgl1.PostgraduateLoanStop;
import java.util.Date;
import java.util.List;

public class PostgraduateLoanEndDPSMessage
extends AbstractDPSMessage<PostgraduateLoanStop>
implements IPGL2Message {
    private String nino;
    private String worksNumber;
    private String surname;
    private List<String> forename;
    private Date stopDate;

    public PostgraduateLoanEndDPSMessage(PostgraduateLoanStop content, byte[] data) {
        super(content, "http://www.govtalk.gov.uk/taxation/PostgraduateLoanEnd/1", data);
        this.worksNumber = content.getWorksNumber();
        this.forename = content.getName().getForename();
        this.surname = content.getName().getSurname();
        this.stopDate = content.getLoanStopDate().toGregorianCalendar().getTime();
        this.nino = content.getNINO();
    }

    @Override
    protected long mapSequenceNumber(PostgraduateLoanStop parsedMessage) {
        return parsedMessage.getSequenceNumber();
    }

    @Override
    protected String mapEmpRef(PostgraduateLoanStop parsedMessage) {
        return parsedMessage.getEmployerRef();
    }

    @Override
    protected String mapSubject(PostgraduateLoanStop parsedMessage) {
        return this.employee(parsedMessage.getName().getForename(), parsedMessage.getName().getSurname(), parsedMessage.getWorksNumber(), parsedMessage.getNINO());
    }

    @Override
    protected FormType mapFormType(PostgraduateLoanStop parsedMessage) {
        return FormType.PGL2;
    }

    @Override
    protected Date mapIssueDate(PostgraduateLoanStop parsedMessage) {
        return parsedMessage.getIssueDate().toGregorianCalendar().getTime();
    }

    @Override
    protected String mapHMRCoffice(PostgraduateLoanStop parsedMessage) {
        return "";
    }

    @Override
    protected int mapTaxYearEnd(PostgraduateLoanStop parsedMessage) {
        return Integer.parseInt(parsedMessage.getTaxYearEnd());
    }

    @Override
    public String getNino() {
        return this.nino;
    }

    @Override
    public String getWorksNumber() {
        return this.worksNumber;
    }

    @Override
    public String getSurname() {
        return this.surname;
    }

    @Override
    public List<String> getForename() {
        return this.forename;
    }

    @Override
    public Date getStopDate() {
        return this.stopDate;
    }

    @Override
    public String getPayrollWarningMessage() {
        return null;
    }
}

