/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.dps;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IP35NotificationMessage;
import com.selima.fbi.core.standard.AbstractDPSMessage;
import com.selima.fbi.core.standard.generated.p35.P35Notif;
import java.util.Date;

public class P35NotifDPSMessage
extends AbstractDPSMessage<P35Notif>
implements IP35NotificationMessage {
    private String accountsOfficeReference;
    private String employerName;
    private String headerText;
    private String notificationText;

    public P35NotifDPSMessage(P35Notif content, byte[] data) {
        super(content, "http://www.govtalk.gov.uk/taxation/P35Notif/2", data);
        this.accountsOfficeReference = content.getEmployerDetails().getAORef();
        this.employerName = content.getEmployerDetails().getName();
        this.notificationText = content.getNotificationText();
        this.headerText = content.getHeaderText();
    }

    @Override
    protected long mapSequenceNumber(P35Notif parsedMessage) {
        return parsedMessage.getSequenceNumber();
    }

    @Override
    protected String mapEmpRef(P35Notif parsedMessage) {
        return parsedMessage.getEmployerDetails().getEmployerRef();
    }

    @Override
    protected String mapSubject(P35Notif parsedMessage) {
        return "Employer's Notification to complete a P35 - Employer's Annual return";
    }

    @Override
    protected FormType mapFormType(P35Notif parsedMessage) {
        return FormType.P35Not;
    }

    @Override
    protected Date mapIssueDate(P35Notif parsedMessage) {
        return parsedMessage.getIssueDate().toGregorianCalendar().getTime();
    }

    @Override
    protected String mapHMRCoffice(P35Notif parsedMessage) {
        return parsedMessage.getEmployerDetails().getHMRCoffice().getName();
    }

    @Override
    protected int mapTaxYearEnd(P35Notif parsedMessage) {
        return Integer.parseInt(parsedMessage.getTaxYearEnd());
    }

    @Override
    public String getAccountsOfficeReference() {
        return this.accountsOfficeReference;
    }

    @Override
    public String getEmployerName() {
        return this.employerName;
    }

    @Override
    public String getHMRCOffice() {
        return this.hmrcOffice;
    }

    @Override
    public String getHeaderText() {
        return this.headerText;
    }

    @Override
    public String getNotificationText() {
        return this.notificationText;
    }

    @Override
    public String getPayrollWarningMessage() {
        return null;
    }
}

