/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.dps;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IIncentiveLetterMessage;
import com.selima.fbi.core.standard.AbstractDPSMessage;
import com.selima.fbi.core.standard.generated.inclet.IncentiveLetter;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class IncentiveLetterDPSMessage
extends AbstractDPSMessage<IncentiveLetter>
implements IIncentiveLetterMessage {
    private Number incentiveAmount;
    private List<String> employerNames;

    public IncentiveLetterDPSMessage(IncentiveLetter content, byte[] data) {
        super(content, "http://www.govtalk.gov.uk/taxation/Incentive/2", data);
        this.incentiveAmount = content.getIncentiveAmount().getValue();
        this.employerNames = content.getEmployerDetails().getName();
    }

    @Override
    protected long mapSequenceNumber(IncentiveLetter parsedMessage) {
        return parsedMessage.getSequenceNumber();
    }

    @Override
    protected String mapEmpRef(IncentiveLetter parsedMessage) {
        return parsedMessage.getEmployerDetails().getEmployerRef();
    }

    @Override
    protected String mapSubject(IncentiveLetter parsedMessage) {
        return "Your " + DecimalFormat.getCurrencyInstance(Locale.UK).format(parsedMessage.getIncentiveAmount().getValue()) + " for filing your " + parsedMessage.getFirstTaxYear() + "-" + parsedMessage.getSecondTaxYear().substring(2) + " Employer's Annual Return online";
    }

    @Override
    protected FormType mapFormType(IncentiveLetter parsedMessage) {
        return FormType.valueOf(parsedMessage.getFormType());
    }

    @Override
    protected Date mapIssueDate(IncentiveLetter parsedMessage) {
        return parsedMessage.getIssueDate().toGregorianCalendar().getTime();
    }

    @Override
    protected String mapHMRCoffice(IncentiveLetter parsedMessage) {
        return "";
    }

    @Override
    protected int mapTaxYearEnd(IncentiveLetter parsedMessage) {
        return Integer.parseInt(parsedMessage.getSecondTaxYear());
    }

    @Override
    public List<String> getEmployerNames() {
        return this.employerNames;
    }

    @Override
    public Number getIncentiveAmount() {
        return this.incentiveAmount;
    }

    @Override
    public String getPayrollWarningMessage() {
        return null;
    }
}

