/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.dps;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IP6P6BMessage;
import com.selima.fbi.core.standard.AbstractDPSMessage;
import com.selima.fbi.core.standard.generated.p6p6b.CodingNoticesP6P6B;
import com.selima.fbi.core.standard.generated.p6p6b.HMRCnonNegativeMonetaryStructure;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public class CodingNoticesP6P6BDPSMessage
extends AbstractDPSMessage<CodingNoticesP6P6B>
implements IP6P6BMessage {
    private Date effectiveDate;
    private List<String> forename;
    private boolean week1Month1Indicator;
    private String nino;
    private String taxCode;
    private String worksNumber;
    private String surname;
    private Number totalPreviousPay;
    private Number totalPreviousTax;
    private String taxRegime;

    public CodingNoticesP6P6BDPSMessage(CodingNoticesP6P6B parsedMessage, byte[] data) {
        super(parsedMessage, "http://www.govtalk.gov.uk/taxation/CodingNoticesP6P6B/2", data);
        HMRCnonNegativeMonetaryStructure hmrcPay;
        XMLGregorianCalendar calendar = parsedMessage.getEffectiveDate();
        this.effectiveDate = calendar.toGregorianCalendar().getTime();
        this.nino = parsedMessage.getNINO();
        this.worksNumber = parsedMessage.getWorksNumber();
        this.surname = parsedMessage.getName().getSurname();
        this.forename = parsedMessage.getName().getForename();
        this.taxCode = parsedMessage.getCodingUpdate().getTaxCode().getValue();
        this.week1Month1Indicator = "X".equals(parsedMessage.getCodingUpdate().getTaxCode().getWeek1Month1Indicator());
        HMRCnonNegativeMonetaryStructure hmrcTax = parsedMessage.getCodingUpdate().getTotalPreviousTax();
        if (hmrcTax != null) {
            this.totalPreviousTax = hmrcTax.getValue();
        }
        if ((hmrcPay = parsedMessage.getCodingUpdate().getTotalPreviousPay()) != null) {
            this.totalPreviousPay = hmrcPay.getValue();
        }
        this.taxRegime = parsedMessage.getCodingUpdate().getTaxCode().getTaxRegime();
    }

    @Override
    protected String mapEmpRef(CodingNoticesP6P6B parsedMessage) {
        return parsedMessage.getEmployerRef();
    }

    @Override
    protected long mapSequenceNumber(CodingNoticesP6P6B parsedMessage) {
        return parsedMessage.getSequenceNumber();
    }

    @Override
    protected String mapSubject(CodingNoticesP6P6B parsedMessage) {
        return this.employee(parsedMessage.getName().getForename(), parsedMessage.getName().getSurname(), parsedMessage.getWorksNumber(), parsedMessage.getNINO());
    }

    @Override
    protected FormType mapFormType(CodingNoticesP6P6B parsedMessage) {
        return FormType.valueOf(parsedMessage.getFormType());
    }

    @Override
    protected Date mapIssueDate(CodingNoticesP6P6B parsedMessage) {
        return parsedMessage.getIssueDate().toGregorianCalendar().getTime();
    }

    @Override
    protected String mapHMRCoffice(CodingNoticesP6P6B parsedMessage) {
        return "";
    }

    @Override
    protected int mapTaxYearEnd(CodingNoticesP6P6B parsedMessage) {
        return Integer.parseInt(parsedMessage.getTaxYearEnd());
    }

    @Override
    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    @Override
    public String getNino() {
        return this.nino;
    }

    @Override
    public Number getTotalPreviousPay() {
        return this.totalPreviousPay;
    }

    @Override
    public Number getTotalPreviousTax() {
        return this.totalPreviousTax;
    }

    @Override
    public String getTaxCode() {
        return this.taxCode;
    }

    @Override
    public boolean getWeek1Month1Indicator() {
        return this.week1Month1Indicator;
    }

    @Override
    public String getWorksNumber() {
        return this.worksNumber;
    }

    @Override
    public String getSurname() {
        return this.surname;
    }

    @Override
    public List<String> getForename() {
        return this.forename;
    }

    @Override
    public String getTaxRegime() {
        return this.taxRegime;
    }

    @Override
    public String getPayrollWarningMessage() {
        return null;
    }

    public boolean requiresLivePlugin2015() {
        return this.taxRegime != null;
    }
}

