/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard;

import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.standard.AbstractMailMessage;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public abstract class AbstractDPSMessage<T>
extends AbstractMailMessage<T>
implements IDPSMessage {
    boolean read;
    final long sequenceNumber;
    protected final String hmrcOffice;

    protected AbstractDPSMessage(T parsedMessage, String namespace, byte[] xml) {
        super(parsedMessage, namespace, xml);
        this.sequenceNumber = this.mapSequenceNumber(parsedMessage);
        this.hmrcOffice = this.mapHMRCoffice(parsedMessage);
    }

    protected abstract long mapSequenceNumber(T var1);

    protected abstract String mapHMRCoffice(T var1);

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getHMRCoffice() {
        return this.hmrcOffice;
    }

    @Override
    public String getStoreId() {
        return this.getFormType().name() + '-' + this.sequenceNumber + '-' + this.getStoreSpace();
    }

    @Override
    public boolean isRead() {
        return this.read;
    }

    @Override
    public void markRead() {
        this.read = true;
    }

    @Override
    public void transfer(boolean firstInBatch) throws IOException {
    }

    @Override
    public boolean isTransferred() {
        return false;
    }

    @Override
    public boolean isTransferrable() {
        return false;
    }

    @Override
    public Date getTransferDate() {
        return null;
    }

    @Override
    public boolean isDeletable() {
        return true;
    }

    protected String employee(List<String> foreName, String surName, String worksNum, String nino) {
        StringBuilder result = new StringBuilder();
        if (nino != null) {
            result.append(nino);
        }
        if (worksNum != null && worksNum.length() > 0) {
            result.append(" (").append(worksNum).append(") ");
        }
        for (String namePart : foreName) {
            result.append(' ').append(namePart);
        }
        result.append(' ').append(surName);
        return result.toString();
    }
}

