/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.payebeans.rti2016.impl;

import com.selima.fbi.core.YesNoEnum;
import com.selima.fbi.core.payebeans.PropertyValidationException;
import com.selima.fbi.core.payebeans.impl.XMLWriter;
import com.selima.fbi.core.payebeans.impl.YesType;
import com.selima.fbi.core.payebeans.rti2016.IEPSBeanMessage2016;
import com.selima.fbi.core.payebeans.rti2016.impl.EPSBeanMessage2016Beyond;
import com.selima.fbi.sender.ISenderDetails;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.xml.stream.XMLStreamException;

public class EPSBeanMessage2016
extends EPSBeanMessage2016Beyond
implements IEPSBeanMessage2016,
PropertyChangeListener {
    protected YesType questionsAndDeclarationsNotFilled;
    protected YesNoEnum freeOfTaxPaymentsMadeToEmployee;
    protected YesNoEnum initialFreeOfTaxPaymentsMadeToEmployee;
    protected YesNoEnum expensesVouchersOrBenefitsFromOthers;
    protected YesNoEnum initialExpensesVouchersOrBenefitsFromOthers;
    protected YesNoEnum personEmployedOutsideUKWorkedFor30DaysOrMore;
    protected YesNoEnum initialPersonEmployedOutsideUKWorkedFor30DaysOrMore;
    protected YesNoEnum payToSomeoneElse;
    protected YesNoEnum initialPayToSomeoneElse;
    protected YesNoEnum p11DFormsDue;
    protected YesNoEnum initialP11DFormsDue;
    protected YesNoEnum serviceCompany;
    protected YesNoEnum initialServiceCompany;

    public EPSBeanMessage2016(int taxYear, ISenderDetails senderDetails, String empRef) {
        super("http://www.govtalk.gov.uk/taxation/PAYE/RTI/EmployerPaymentSummary/15-16/1", taxYear, senderDetails, empRef);
        this.addPropertyChangeListener(this);
    }

    @Override
    public YesType getQuestionsAndDeclarationsNotFilled() {
        return this.questionsAndDeclarationsNotFilled;
    }

    @Override
    public void setQuestionsAndDeclarationsNotFilled(YesType value) {
        this.questionsAndDeclarationsNotFilled = value;
    }

    @Override
    public void resetQuestionsAndDeclarationsNotFilled() {
        this.questionsAndDeclarationsNotFilled = this.calculateQuestionsAndDeclarationsNotFilled();
    }

    @Override
    public YesNoEnum getFreeOfTaxPaymentsMadeToEmployee() {
        return this.freeOfTaxPaymentsMadeToEmployee;
    }

    public void initFreeOfTaxPaymentsMadeToEmployee(YesNoEnum freeOfTaxPaymentsMadeToEmployee) {
        this.initialFreeOfTaxPaymentsMadeToEmployee = this.freeOfTaxPaymentsMadeToEmployee = freeOfTaxPaymentsMadeToEmployee;
    }

    @Override
    public void resetFreeOfTaxPaymentsMadeToEmployee() {
        this.freeOfTaxPaymentsMadeToEmployee = this.initialFreeOfTaxPaymentsMadeToEmployee;
    }

    @Override
    public void setFreeOfTaxPaymentsMadeToEmployee(YesNoEnum value) throws PropertyValidationException {
        this.freeOfTaxPaymentsMadeToEmployee = value;
    }

    @Override
    public YesNoEnum getExpensesVouchersOrBenefitsFromOthers() {
        return this.expensesVouchersOrBenefitsFromOthers;
    }

    public void initExpensesVouchersOrBenefitsFromOthers(YesNoEnum expensesVouchersOrBenefitsFromOthers) {
        this.initialExpensesVouchersOrBenefitsFromOthers = this.expensesVouchersOrBenefitsFromOthers = expensesVouchersOrBenefitsFromOthers;
    }

    @Override
    public void resetExpensesVouchersOrBenefitsFromOthers() {
        this.expensesVouchersOrBenefitsFromOthers = this.initialExpensesVouchersOrBenefitsFromOthers;
    }

    @Override
    public void setExpensesVouchersOrBenefitsFromOthers(YesNoEnum value) throws PropertyValidationException {
        this.expensesVouchersOrBenefitsFromOthers = value;
    }

    @Override
    public YesNoEnum getPersonEmployedOutsideUKWorkedFor30DaysOrMore() {
        return this.personEmployedOutsideUKWorkedFor30DaysOrMore;
    }

    public void initPersonEmployedOutsideUKWorkedFor30DaysOrMore(YesNoEnum personEmployedOutsideUKWorkedFor30DaysOrMore) {
        this.initialPersonEmployedOutsideUKWorkedFor30DaysOrMore = this.personEmployedOutsideUKWorkedFor30DaysOrMore = personEmployedOutsideUKWorkedFor30DaysOrMore;
    }

    @Override
    public void resetPersonEmployedOutsideUKWorkedFor30DaysOrMore() {
        this.personEmployedOutsideUKWorkedFor30DaysOrMore = this.initialPersonEmployedOutsideUKWorkedFor30DaysOrMore;
    }

    @Override
    public void setPersonEmployedOutsideUKWorkedFor30DaysOrMore(YesNoEnum value) throws PropertyValidationException {
        this.personEmployedOutsideUKWorkedFor30DaysOrMore = value;
    }

    @Override
    public YesNoEnum getPayToSomeoneElse() {
        return this.payToSomeoneElse;
    }

    public void initPayToSomeoneElse(YesNoEnum payToSomeoneElse) {
        this.initialPayToSomeoneElse = this.payToSomeoneElse = payToSomeoneElse;
    }

    @Override
    public void resetPayToSomeoneElse() {
        this.payToSomeoneElse = this.initialPayToSomeoneElse;
    }

    @Override
    public void setPayToSomeoneElse(YesNoEnum value) throws PropertyValidationException {
        this.payToSomeoneElse = value;
    }

    @Override
    public YesNoEnum getP11DFormsDue() {
        return this.p11DFormsDue;
    }

    public void initP11DFormsDue(YesNoEnum p11dFormsDue) {
        this.initialP11DFormsDue = this.p11DFormsDue = p11dFormsDue;
    }

    @Override
    public void resetP11DFormsDue() {
        this.p11DFormsDue = this.initialP11DFormsDue;
    }

    @Override
    public void setP11DFormsDue(YesNoEnum value) throws PropertyValidationException {
        this.p11DFormsDue = value;
    }

    @Override
    public YesNoEnum getServiceCompany() {
        return this.serviceCompany;
    }

    public void initServiceCompany(YesNoEnum serviceCompany) {
        this.initialServiceCompany = this.serviceCompany = serviceCompany;
    }

    @Override
    public void resetServiceCompany() {
        this.serviceCompany = this.initialServiceCompany;
    }

    @Override
    public void setServiceCompany(YesNoEnum value) throws PropertyValidationException {
        this.serviceCompany = value;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "freeOfTaxPaymentsMadeToEmployee": 
            case "expensesVouchersOrBenefitsFromOthers": 
            case "personEmployedOutsideUKWorkedFor30DaysOrMore": 
            case "payToSomeoneElse": 
            case "p11DFormsDue": 
            case "serviceCompany": {
                if ((evt.getNewValue() == null || this.questionsAndDeclarationsNotFilled != YesType.yes) && (evt.getNewValue() != null || this.questionsAndDeclarationsNotFilled != null)) break;
                YesType oldValue = this.questionsAndDeclarationsNotFilled;
                YesType newValue = this.questionsAndDeclarationsNotFilled = this.calculateQuestionsAndDeclarationsNotFilled();
                this.changeSupport.firePropertyChange("questionsAndDeclarationsNotFilled", (Object)oldValue, (Object)newValue);
            }
        }
    }

    private YesType calculateQuestionsAndDeclarationsNotFilled() {
        return this.hasQuestionsAndDeclarations() ? null : YesType.yes;
    }

    private boolean hasQuestionsAndDeclarations() {
        return this.freeOfTaxPaymentsMadeToEmployee != null || this.expensesVouchersOrBenefitsFromOthers != null || this.personEmployedOutsideUKWorkedFor30DaysOrMore != null || this.payToSomeoneElse != null || this.p11DFormsDue != null || this.serviceCompany != null;
    }

    @Override
    protected void writePayloadToXml(XMLWriter writer) throws XMLStreamException {
        writer.openTag("EmployerPaymentSummary", new String[0]).openTag("EmpRefs", new String[0]).element("OfficeNo", this.officeNo, new String[0]).element("PayeRef", this.payeRef, new String[0]).element("AORef", this.aoRef, new String[0]).closeTag();
        if (this.noPaymentDateFrom != null || this.noPaymentDateTo != null) {
            writer.element("NoPaymentForPeriod", YesType.yes, new Object[0]).openTag("NoPaymentDates", new String[0]).dateElement("From", this.noPaymentDateFrom, new String[0]).dateElement("To", this.noPaymentDateTo, new String[0]).closeTag();
        }
        if (this.periodOfInactivityFrom != null || this.periodOfInactivityTo != null) {
            writer.openTag("PeriodOfInactivity", new String[0]).dateElement("From", this.periodOfInactivityFrom, new String[0]).dateElement("To", this.periodOfInactivityTo, new String[0]).closeTag();
        }
        writer.element("EmpAllceInd", this.empAllceInd, new Object[0]);
        if (this.hasRecoverables()) {
            writer.openTag("RecoverableAmountsYTD", new String[0]).intElement("TaxMonth", this.taxMonth, new String[0]).decElement("SMPRecovered", this.smpRecovered, new String[0]).decElement("SPPRecovered", this.sppRecovered, new String[0]).decElement("SAPRecovered", this.sapRecovered, new String[0]).decElement("ShPPRecovered", this.shppRecovered, new String[0]).decElement("NICCompensationOnSMP", this.nicCompensationOnSMP, new String[0]).decElement("NICCompensationOnSPP", this.nicCompensationOnSPP, new String[0]).decElement("NICCompensationOnSAP", this.nicCompensationOnSAP, new String[0]).decElement("NICCompensationOnShPP", this.nicCompensationOnShPP, new String[0]).decElement("CISDeductionsSuffered", this.cisDeductionsSuffered, new String[0]).closeTag();
        }
        if (this.accountHoldersName != null || this.accountNo != null || this.sortCode != null || this.buildingSocRef != null) {
            writer.openTag("Account", new String[0]).element("AccountHoldersName", this.accountHoldersName, new String[0]).element("AccountNo", this.accountNo, new String[0]).element("SortCode", this.sortCode, new String[0]).element("BuildingSocRef", this.buildingSocRef, new String[0]).closeTag();
        }
        writer.taxYearElement("RelatedTaxYear", this.getTaxYearEnd());
        if (this.finalSubmissionBecauseSchemeCeased == YesType.yes || this.finalSubmissionForYear == YesType.yes) {
            writer.openTag("FinalSubmission", new String[0]).element("BecauseSchemeCeased", this.finalSubmissionBecauseSchemeCeased, new Object[0]).dateElement("DateSchemeCeased", this.dateSchemeCeased, new String[0]).element("ForYear", this.finalSubmissionForYear, new Object[0]).closeTag();
        }
        if (this.questionsAndDeclarationsNotFilled == null) {
            writer.openTag("QuestionsAndDeclarations", new String[0]).element("FreeOfTaxPaymentsMadeToEmployee", this.freeOfTaxPaymentsMadeToEmployee, new Object[0]).element("ExpensesVouchersOrBenefitsFromOthers", this.expensesVouchersOrBenefitsFromOthers, new Object[0]).element("PersonEmployedOutsideUKWorkedFor30DaysOrMore", this.personEmployedOutsideUKWorkedFor30DaysOrMore, new Object[0]).element("PayToSomeoneElse", this.payToSomeoneElse, new Object[0]).element("P11DFormsDue", this.p11DFormsDue, new Object[0]).element("ServiceCompany", this.serviceCompany, new Object[0]).closeTag();
        }
        writer.closeTag();
    }
}

