/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.payebeans.rti2014.impl;

import com.selima.fbi.core.YesNoEnum;
import com.selima.fbi.core.payebeans.impl.YesType;
import com.selima.fbi.core.payebeans.rti2014.impl.EPSBeanMessage2014;
import com.selima.fbi.core.payebeans.rti2014.impl.Tools;
import com.selima.fbi.core.standard.generated.eps2014.EmployerPaymentSummary;
import com.selima.fbi.core.standard.generated.eps2014.IRenvelope;
import com.selima.fbi.sender.ParsedSenderDetails;
import javax.xml.datatype.XMLGregorianCalendar;

public class ParsedEPSBeanMessage2014
extends EPSBeanMessage2014 {
    public ParsedEPSBeanMessage2014(IRenvelope envelope) {
        super(envelope.getIRheader().getPeriodEnd().getYear(), new ParsedSenderDetails(envelope), Tools.parsedTaxRef(envelope));
        EmployerPaymentSummary employerPaymentSummary = envelope.getEmployerPaymentSummary();
        if (employerPaymentSummary != null) {
            EmployerPaymentSummary.QuestionsAndDeclarations questionsAndDeclarations;
            EmployerPaymentSummary.FinalSubmission finalSubmission;
            EmployerPaymentSummary.PeriodOfInactivity periodOfInactivity;
            EmployerPaymentSummary.NoPaymentDates noPaymentDates;
            EmployerPaymentSummary.RecoverableAmountsYTD recoverableAmountsYTD;
            EmployerPaymentSummary.EmpRefs empRefs = employerPaymentSummary.getEmpRefs();
            if (empRefs != null) {
                this.initAORef(empRefs.getAORef());
                this.initOfficeNo(empRefs.getOfficeNo());
                this.initPayeRef(empRefs.getPayeRef());
            }
            if ((recoverableAmountsYTD = employerPaymentSummary.getRecoverableAmountsYTD()) != null) {
                this.initAsppRecovered(recoverableAmountsYTD.getASPPRecovered());
                this.initCisDeductionsSuffered(recoverableAmountsYTD.getCISDeductionsSuffered());
                this.initNicCompensationOnASPP(recoverableAmountsYTD.getNICCompensationOnASPP());
                this.initNicCompensationOnOSPP(recoverableAmountsYTD.getNICCompensationOnOSPP());
                this.initNicCompensationOnSAP(recoverableAmountsYTD.getNICCompensationOnSAP());
                this.initNicCompensationOnSMP(recoverableAmountsYTD.getNICCompensationOnSMP());
                this.initSmpRecovered(recoverableAmountsYTD.getSMPRecovered());
                this.initSspRecovered(recoverableAmountsYTD.getSSPRecovered());
                this.initNicsHoliday(recoverableAmountsYTD.getNICsHoliday());
                this.initOsppRecovered(recoverableAmountsYTD.getOSPPRecovered());
                this.initSapRecovered(recoverableAmountsYTD.getSAPRecovered());
            }
            if ((noPaymentDates = employerPaymentSummary.getNoPaymentDates()) != null) {
                XMLGregorianCalendar to;
                XMLGregorianCalendar from = noPaymentDates.getFrom();
                if (from != null) {
                    this.initNoPaymentDateFrom(from.toGregorianCalendar().getTime());
                }
                if ((to = noPaymentDates.getTo()) != null) {
                    this.initNoPaymentDateTo(to.toGregorianCalendar().getTime());
                }
            }
            if ((periodOfInactivity = employerPaymentSummary.getPeriodOfInactivity()) != null) {
                XMLGregorianCalendar to;
                XMLGregorianCalendar from = periodOfInactivity.getFrom();
                if (from != null) {
                    this.initPeriodOfInactivityFrom(from.toGregorianCalendar().getTime());
                }
                if ((to = periodOfInactivity.getTo()) != null) {
                    this.initPeriodOfInactivityTo(to.toGregorianCalendar().getTime());
                }
            }
            if ((finalSubmission = employerPaymentSummary.getFinalSubmission()) != null) {
                XMLGregorianCalendar dateSchemeCeased = finalSubmission.getDateSchemeCeased();
                if (dateSchemeCeased != null) {
                    this.initDateSchemeCeased(dateSchemeCeased.toGregorianCalendar().getTime());
                }
                this.initFinalSubmissionBecauseSchemeCeased(YesType.fromJaxb(finalSubmission.getBecauseSchemeCeased()));
                this.initFinalSubmissionForYear(YesType.fromJaxb(finalSubmission.getForYear()));
            }
            if ((questionsAndDeclarations = employerPaymentSummary.getQuestionsAndDeclarations()) != null) {
                this.initP11DFormsDue(YesNoEnum.valueOfJaxb((Object)questionsAndDeclarations.getP11DFormsDue()));
                this.initPayToSomeoneElse(YesNoEnum.valueOfJaxb((Object)questionsAndDeclarations.getPayToSomeoneElse()));
                this.initPersonEmployedOutsideUKWorkedFor30DaysOrMore(YesNoEnum.valueOfJaxb((Object)questionsAndDeclarations.getPersonEmployedOutsideUKWorkedFor30DaysOrMore()));
                this.initServiceCompany(YesNoEnum.valueOfJaxb((Object)questionsAndDeclarations.getServiceCompany()));
                this.initExpensesVouchersOrBenefitsFromOthers(YesNoEnum.valueOfJaxb((Object)questionsAndDeclarations.getExpensesVouchersOrBenefitsFromOthers()));
                this.initFreeOfTaxPaymentsMadeToEmployee(YesNoEnum.valueOfJaxb((Object)questionsAndDeclarations.getFreeOfTaxPaymentsMadeToEmployee()));
            }
        }
    }
}

