/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.payebeans.impl;

import com.selima.fbi.core.payebeans.IBean;
import com.selima.fbi.core.payebeans.IResetListener;
import com.selima.fbi.core.payebeans.impl.BaseBean;
import com.selima.fbi.util.ReflectionUtil;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WrappingPropertyChangeSupport
extends PropertyChangeSupport {
    Map<String, EventBroadcast<IResetListener>> resetListeners = new HashMap<String, EventBroadcast<IResetListener>>();
    Object proxy;
    static Map<Class<?>, ReflectionInfo> reflectionCache = new HashMap();

    public WrappingPropertyChangeSupport(BaseBean bean) {
        this(WrappingPropertyChangeSupport.createProxy(bean));
    }

    public void fireReset(String name) {
        EventBroadcast<IResetListener> listeners = this.resetListeners.get(name);
        if (listeners != null) {
            ((IResetListener)listeners.getListener()).reseted();
        }
    }

    public void addResetListener(String name, IResetListener resetListener) {
        EventBroadcast listeners = this.resetListeners.get(name);
        if (listeners == null) {
            listeners = EventBroadcastFactory.createEventBroadcast(IResetListener.class);
            this.resetListeners.put(name, (EventBroadcast<IResetListener>)listeners);
        }
        listeners.addListener((Object)resetListener);
    }

    public void removeResetListener(String name, IResetListener resetListener) {
        EventBroadcast<IResetListener> listeners = this.resetListeners.get(name);
        listeners.removeListener((Object)resetListener);
        if (listeners.isEmpty()) {
            this.resetListeners.remove(name);
        }
    }

    WrappingPropertyChangeSupport(Object proxy) {
        super(proxy);
        this.proxy = proxy;
    }

    private static Object createProxy(BaseBean bean) {
        ReflectionInfo reflectionInfo = reflectionCache.get(bean.getClass());
        if (reflectionInfo == null) {
            reflectionInfo = new ReflectionInfo(bean.getClass());
            reflectionCache.put(bean.getClass(), reflectionInfo);
        }
        try {
            Set<Class<?>> ifaces = ReflectionUtil.getInterfacesSet(bean);
            ifaces.add(WrappingPropertyChangeSupportMarker.class);
            return Proxy.newProxyInstance(bean.getClass().getClassLoader(), ifaces.toArray(new Class[ifaces.size()]), (InvocationHandler)new ProxyHandler(bean, reflectionInfo));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public <InterfaceType> InterfaceType wrap(Class<InterfaceType> type) {
        assert (type != null && type.isInterface()) : "cannot implement concrete class";
        assert (type.isInstance(this.proxy)) : "bean must fullfill the interface";
        return type.cast(this.proxy);
    }

    static class ProxyHandler
    implements InvocationHandler {
        BaseBean bean;
        private Map<Method, Method> setter2getter;
        private Map<Method, String> setter2name;
        private Set<Method> listGetters;
        private Set<Method> rawGetters;
        private Set<Method> resetters;

        ProxyHandler(BaseBean bean, ReflectionInfo info) {
            this.bean = bean;
            this.setter2getter = info.setter2getter;
            this.setter2name = info.setter2name;
            this.listGetters = info.listGetters;
            this.rawGetters = info.rawGetters;
            this.resetters = info.resetters;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                List list;
                ArrayList<IBean> result;
                if (method.getDeclaringClass() == Object.class) {
                    if (args != null) {
                        for (int i = 0; i < args.length; ++i) {
                            if (!proxy.getClass().isInstance(args[i])) continue;
                            args[i] = ((ProxyHandler)Proxy.getInvocationHandler((Object)args[i])).bean;
                        }
                    }
                    return method.invoke((Object)this.bean, args);
                }
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        if (!(args[i] instanceof List)) continue;
                        List oldList = (List)args[i];
                        ArrayList<Object> newList = new ArrayList<Object>(oldList.size());
                        for (Object oldValue : oldList) {
                            newList.add(this.unwrapProxy(oldValue));
                        }
                        args[i] = newList;
                    }
                }
                if (this.setter2getter.containsKey(method)) {
                    Object old = this.setter2getter.get(method).invoke((Object)this.bean, new Object[0]);
                    method.invoke((Object)this.bean, args);
                    Object newValue = args != null && args.length > 0 ? args[0] : this.setter2getter.get(method).invoke((Object)this.bean, new Object[0]);
                    String propertyName = this.setter2name.get(method);
                    this.bean.changeSupport.firePropertyChange(propertyName, old, newValue);
                    if (this.resetters.contains(method)) {
                        this.bean.changeSupport.fireReset(propertyName);
                    }
                    result = null;
                } else {
                    result = method.invoke((Object)this.bean, args);
                }
                if (this.rawGetters.contains(method)) {
                    if (result instanceof BaseBean) {
                        BaseBean bean = (BaseBean)((Object)result);
                        result = bean.getProxy(method.getReturnType());
                    }
                } else if (this.listGetters.contains(method) && !(list = (List)result).isEmpty()) {
                    ArrayList<IBean> clonedList = new ArrayList<IBean>(list.size());
                    for (Object value : list) {
                        if (value instanceof BaseBean) {
                            BaseBean bean = (BaseBean)value;
                            clonedList.add(bean.getProxy(IBean.class));
                            continue;
                        }
                        clonedList.add((IBean)value);
                    }
                    result = clonedList;
                }
                return result;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private Object unwrapProxy(Object arg) {
            if (arg instanceof WrappingPropertyChangeSupportMarker) {
                ProxyHandler handler = (ProxyHandler)Proxy.getInvocationHandler(arg);
                return handler.bean;
            }
            return arg;
        }
    }

    static class ReflectionInfo {
        Map<Method, Method> setter2getter;
        Map<Method, String> setter2name;
        Set<Method> listGetters;
        Set<Method> rawGetters;
        Set<Method> resetters;

        ReflectionInfo(Class<?> beanType) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(beanType, BaseBean.class);
                PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
                this.setter2getter = new HashMap<Method, Method>(props.length);
                this.setter2name = new HashMap<Method, String>(props.length);
                this.listGetters = new HashSet<Method>(2);
                this.rawGetters = new HashSet<Method>(2);
                this.resetters = new HashSet<Method>(props.length);
                Class<?>[] ifaces = ReflectionUtil.getInterfaces(beanType);
                for (PropertyDescriptor property : props) {
                    Method interfaceGetter;
                    Method writeMethod = property.getWriteMethod();
                    Method readMethod = property.getReadMethod();
                    if (writeMethod != null) {
                        assert (readMethod != null) : "write only properties not supported";
                        Method interfaceSetter = this.findMethod(ifaces, writeMethod);
                        if (interfaceSetter != null) {
                            this.setter2getter.put(interfaceSetter, readMethod);
                            this.setter2name.put(interfaceSetter, property.getName());
                            Method resetter = this.findResetMethod(ifaces, writeMethod);
                            if (resetter != null) {
                                this.setter2getter.put(resetter, readMethod);
                                this.setter2name.put(resetter, property.getName());
                                this.resetters.add(resetter);
                            }
                        }
                    }
                    if (IBean.class.isAssignableFrom(readMethod.getReturnType()) && (interfaceGetter = this.findMethod(ifaces, readMethod)) != null) {
                        this.rawGetters.add(interfaceGetter);
                    }
                    if (!List.class.isAssignableFrom(readMethod.getReturnType()) || (interfaceGetter = this.findMethod(ifaces, readMethod)) == null) continue;
                    this.listGetters.add(interfaceGetter);
                }
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException("Wrong JavaBean: " + beanType, e);
            }
        }

        private Method findMethod(Class<?>[] ifaces, Method writeMethod) {
            for (Class<?> iface : ifaces) {
                try {
                    return iface.getMethod(writeMethod.getName(), writeMethod.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                }
            }
            return null;
        }

        private Method findResetMethod(Class<?>[] ifaces, Method writeMethod) {
            for (Class<?> iface : ifaces) {
                try {
                    return iface.getMethod("re" + writeMethod.getName(), new Class[0]);
                }
                catch (NoSuchMethodException e) {
                }
            }
            return null;
        }
    }

    public static interface WrappingPropertyChangeSupportMarker {
    }
}

