/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.payebeans.impl;

import com.selima.fbi.FormType;
import com.selima.fbi.core.payebeans.IEPSBeanMessage;
import com.selima.fbi.core.payebeans.PropertyValidationException;
import com.selima.fbi.core.payebeans.impl.AbstractBeanMessage;
import com.selima.fbi.core.payebeans.impl.YesType;
import com.selima.fbi.sender.ISenderDetails;
import java.util.Date;
import java.util.GregorianCalendar;

public abstract class EPSBeanMessage
extends AbstractBeanMessage
implements IEPSBeanMessage {
    protected String officeNo;
    protected String payeRef;
    protected String aoRef;
    protected Date noPaymentDateFrom;
    protected Date noPaymentDateTo;
    protected Date periodOfInactivityFrom;
    protected Date periodOfInactivityTo;
    protected Number smpRecovered;
    protected Number initialSmpRecovered;
    protected Number sapRecovered;
    protected Number initialSapRecovered;
    protected Number nicCompensationOnSMP;
    protected Number initialNicCompensationOnSMP;
    protected Number nicCompensationOnSAP;
    protected Number initialNicCompensationOnSAP;
    protected Number cisDeductionsSuffered;
    protected Number initialCisDeductionsSuffered;
    protected YesType finalSubmissionBecauseSchemeCeased;
    protected YesType finalSubmissionForYear;
    protected Date dateSchemeCeased;

    public EPSBeanMessage(String xmlNamespace, int taxYearEnd, ISenderDetails senderDetails, String empRef) {
        super(xmlNamespace, taxYearEnd, senderDetails, empRef);
    }

    @Override
    public FormType getFormType() {
        return FormType.EPS;
    }

    public String getOfficeNo() {
        return this.officeNo;
    }

    public void initOfficeNo(String officeNo) {
        this.officeNo = officeNo;
    }

    public String getPayeRef() {
        return this.payeRef;
    }

    public void initPayeRef(String payeRef) {
        this.payeRef = payeRef;
    }

    public String getAORef() {
        return this.aoRef;
    }

    public void initAORef(String aoRef) {
        this.aoRef = aoRef;
    }

    @Override
    public Date getNoPaymentDateFrom() {
        return this.noPaymentDateFrom;
    }

    public void initNoPaymentDateFrom(Date noPaymentDateFrom) {
        this.noPaymentDateFrom = noPaymentDateFrom;
    }

    @Override
    public void setNoPaymentDateFrom(Date date) throws PropertyValidationException {
        this.checkDateNotBefore("noPaymentDateFrom", date, 6, 3, this.getTaxYearEnd() - 1);
        this.noPaymentDateFrom = date;
    }

    @Override
    public Date getNoPaymentDateTo() {
        return this.noPaymentDateTo;
    }

    public void initNoPaymentDateTo(Date noPaymentDateTo) {
        this.noPaymentDateTo = noPaymentDateTo;
    }

    @Override
    public void setNoPaymentDateTo(Date date) throws PropertyValidationException {
        this.checkDateNotAfter("noPaymentDateTo", date, 5, 3, this.getTaxYearEnd());
        this.noPaymentDateTo = date;
    }

    @Override
    public Date getPeriodOfInactivityFrom() {
        return this.periodOfInactivityFrom;
    }

    public void initPeriodOfInactivityFrom(Date periodOfInactivityFrom) {
        this.periodOfInactivityFrom = periodOfInactivityFrom;
    }

    @Override
    public void setPeriodOfInactivityFrom(Date date) throws PropertyValidationException {
        this.periodOfInactivityFrom = date;
    }

    @Override
    public Date getPeriodOfInactivityTo() {
        return this.periodOfInactivityTo;
    }

    public void initPeriodOfInactivityTo(Date periodOfInactivityTo) {
        this.periodOfInactivityTo = periodOfInactivityTo;
    }

    @Override
    public void setPeriodOfInactivityTo(Date periodOfInactivityTo) {
        this.periodOfInactivityTo = periodOfInactivityTo;
    }

    @Override
    public Number getSmpRecovered() {
        return this.smpRecovered;
    }

    public void initSmpRecovered(Number smpRecovered) {
        this.initialSmpRecovered = this.smpRecovered = smpRecovered;
    }

    @Override
    public void resetSmpRecovered() {
        this.smpRecovered = this.initialSmpRecovered;
    }

    @Override
    public void setSmpRecovered(Number value) throws PropertyValidationException {
        this.checkRange("smpRecovered", value, 0.0, 9.999999999E7);
        this.smpRecovered = value;
    }

    @Override
    public Number getSapRecovered() {
        return this.sapRecovered;
    }

    public void initSapRecovered(Number sapRecovered) {
        this.initialSapRecovered = this.sapRecovered = sapRecovered;
    }

    @Override
    public void resetSapRecovered() {
        this.sapRecovered = this.initialSapRecovered;
    }

    @Override
    public void setSapRecovered(Number value) throws PropertyValidationException {
        this.checkRange("sapRecovered", value, 0.0, 9.999999999E7);
        this.sapRecovered = value;
    }

    @Override
    public Number getNicCompensationOnSMP() {
        return this.nicCompensationOnSMP;
    }

    public void initNicCompensationOnSMP(Number nicCompensationOnSMP) {
        this.initialNicCompensationOnSMP = this.nicCompensationOnSMP = nicCompensationOnSMP;
    }

    @Override
    public void resetNicCompensationOnSMP() {
        this.nicCompensationOnSMP = this.initialNicCompensationOnSMP;
    }

    @Override
    public void setNicCompensationOnSMP(Number value) throws PropertyValidationException {
        this.checkRange("nicCompensationOnSMP", value, 0.0, 9.999999999E7);
        this.nicCompensationOnSMP = value;
    }

    @Override
    public Number getNicCompensationOnSAP() {
        return this.nicCompensationOnSAP;
    }

    public void initNicCompensationOnSAP(Number nicCompensationOnSAP) {
        this.initialNicCompensationOnSAP = this.nicCompensationOnSAP = nicCompensationOnSAP;
    }

    @Override
    public void resetNicCompensationOnSAP() {
        this.nicCompensationOnSAP = this.initialNicCompensationOnSAP;
    }

    @Override
    public void setNicCompensationOnSAP(Number value) throws PropertyValidationException {
        this.checkRange("nicCompensationOnSAP", value, 0.0, 9.999999999E7);
        this.nicCompensationOnSAP = value;
    }

    @Override
    public Number getCisDeductionsSuffered() {
        return this.cisDeductionsSuffered;
    }

    public void initCisDeductionsSuffered(Number cisDeductionsSuffered) {
        this.initialCisDeductionsSuffered = this.cisDeductionsSuffered = cisDeductionsSuffered;
    }

    @Override
    public void resetCisDeductionsSuffered() {
        this.cisDeductionsSuffered = this.initialCisDeductionsSuffered;
    }

    @Override
    public void setCisDeductionsSuffered(Number value) throws PropertyValidationException {
        this.checkRange("cisDeductionsSuffered", value, 0.0, 9.99999999999E9);
        this.cisDeductionsSuffered = value;
    }

    @Override
    public YesType getFinalSubmissionBecauseSchemeCeased() {
        return this.finalSubmissionBecauseSchemeCeased;
    }

    public void initFinalSubmissionBecauseSchemeCeased(YesType finalSubmissionBecauseSchemeCeased) {
        this.finalSubmissionBecauseSchemeCeased = finalSubmissionBecauseSchemeCeased;
    }

    @Override
    public void setFinalSubmissionBecauseSchemeCeased(YesType value) throws PropertyValidationException {
        this.finalSubmissionBecauseSchemeCeased = value;
    }

    @Override
    public YesType getFinalSubmissionForYear() {
        return this.finalSubmissionForYear;
    }

    public void initFinalSubmissionForYear(YesType finalSubmissionForYear) {
        this.finalSubmissionForYear = finalSubmissionForYear;
    }

    @Override
    public void setFinalSubmissionForYear(YesType finalSubmissionForYear) {
        this.finalSubmissionForYear = finalSubmissionForYear;
    }

    @Override
    public Date getDateSchemeCeased() {
        return this.dateSchemeCeased;
    }

    public void initDateSchemeCeased(Date dateDateSchemeCeased) {
        this.dateSchemeCeased = dateDateSchemeCeased;
    }

    @Override
    public void setDateSchemeCeased(Date dateSchemeCeased) throws PropertyValidationException {
        this.checkDateNotBefore("dateSchemeCeased", dateSchemeCeased, 6, 3, this.getTaxYearEnd() - 1);
        this.checkDateNotAfter("dateSchemeCeased", dateSchemeCeased, 5, 3, this.getTaxYearEnd());
        this.dateSchemeCeased = dateSchemeCeased;
    }

    protected void checkRange(String property, Number value, double lowerBoundInclusive, double upperBoundInclusive) throws PropertyValidationException {
        if (value != null) {
            if (value.doubleValue() < lowerBoundInclusive) {
                throw new PropertyValidationException(property, value, "Negative value not allowed");
            }
            if (value.doubleValue() > upperBoundInclusive) {
                throw new PropertyValidationException(property, value, "Value must not be greater then 99999999.99");
            }
        }
    }

    protected void checkDateNotBefore(String property, Date date, int day, int month, int year) throws PropertyValidationException {
        GregorianCalendar startYear;
        if (date != null && date.before((startYear = new GregorianCalendar(year, month, day)).getTime())) {
            throw new PropertyValidationException(property, date, String.format("Must not preceed %02d-%02d-%04d ", day, month + 1, year));
        }
    }

    protected void checkDateNotAfter(String property, Date date, int day, int month, int year) throws PropertyValidationException {
        GregorianCalendar yearEnd;
        if (date != null && date.after((yearEnd = new GregorianCalendar(year, month, day)).getTime())) {
            throw new PropertyValidationException(property, date, String.format("Must be on or before  %02d/%02d/%04d ", day, month + 1, year));
        }
    }

    protected void checkDateBeforeToday(String property, Date date) throws PropertyValidationException {
        if (date != null) {
            GregorianCalendar today = new GregorianCalendar();
            today.set(11, 0);
            today.set(12, 0);
            today.set(13, 0);
            if (!date.before(today.getTime())) {
                throw new PropertyValidationException(property, date, "Must be before the current date");
            }
        }
    }

    protected void checkDateNotAfterToday(String property, Date date) throws PropertyValidationException {
        if (date != null) {
            GregorianCalendar today = new GregorianCalendar();
            today.set(11, 0);
            today.set(12, 0);
            today.set(13, 0);
            if (date.after(today.getTime())) {
                throw new PropertyValidationException(property, date, "Must be on or before the current date");
            }
        }
    }
}

