/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.AbstractSimpleFolderFacade;
import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.wrapper.DPSMessageWrapper;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;

public class TransferredFacade
extends AbstractSimpleFolderFacade<IDPSMessage> {
    public TransferredFacade(IMailServiceFacade facade, IStorageFactory storageFactory) {
        super(facade, storageFactory, IDPSMessage.class, Folder.TRANSFERRED);
        this.storageFactory = storageFactory;
    }

    @Override
    public IMailMessage getMessage(Folder folder, String id) throws IOException, CancelException {
        IMailMessage message = super.getMessage(folder, id);
        if (folder != Folder.TRANSFERRED && message instanceof IDPSMessage) {
            message = new TransferableMessage((IDPSMessage)message).getProxy();
        } else if (folder == Folder.TRANSFERRED && message != null) {
            message = new TransferredMessage((IDPSMessage)message).getProxy();
        }
        return message;
    }

    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... emprefs) throws IOException, CancelException {
        List<IMailMessage> result;
        block3: {
            block2: {
                result = super.getMessages(folder, emprefs);
                if (folder == Folder.TRANSFERRED || !IDPSMessage.class.isAssignableFrom(folder.contentType())) break block2;
                ListIterator<IMailMessage> it = result.listIterator();
                while (it.hasNext()) {
                    it.set((IMailMessage)new TransferableMessage((IDPSMessage)it.next()).getProxy());
                }
                break block3;
            }
            if (folder != Folder.TRANSFERRED) break block3;
            ListIterator<IMailMessage> it = result.listIterator();
            while (it.hasNext()) {
                it.set((IMailMessage)new TransferredMessage((IDPSMessage)it.next()).getProxy());
            }
        }
        return result;
    }

    class TransferableMessage
    extends DPSMessageWrapper {
        TransferableMessage(IDPSMessage message) {
            super(message);
        }

        @Override
        public void transfer(boolean firstInBatch) throws IOException, PluginException, CancelException {
            boolean wasTransferred = this.isTransferred();
            super.transfer(firstInBatch);
            if (!wasTransferred && this.isTransferred()) {
                Folder folder = TransferredFacade.this.getMessageFolder(this.getStoreId());
                assert (folder != null && folder != Folder.TRANSFERRED) : "We should not allow this";
                TransferredFacade.this.deleteMessages(folder, this.getStoreId());
                IStorage storage = TransferredFacade.this.getStorage(this.getEmpRef());
                storage.store(this);
            }
        }
    }

    class TransferredMessage
    extends DPSMessageWrapper {
        TransferredMessage(IDPSMessage message) {
            super(message);
        }

        @Override
        public boolean isTransferred() {
            return true;
        }
    }
}

