/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.FormType;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.WrappingFacade;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.SubmitClass;
import com.selima.fbi.core.response.IResponse;
import com.selima.fbi.core.wrapper.DPSMessageWrapper;
import com.selima.fbi.core.wrapper.PAYEMessageWrapper;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.storage.Transaction;
import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.submission.core.body.IStatusReport;
import com.selima.fbi.user.IProxySettings;
import com.selima.fbi.user.IUser;
import com.selima.fbi.user.PayrollServerSpec;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;

public class TransactionalFacade
extends WrappingFacade {
    IStorageFactory storageFactory;

    public TransactionalFacade(IMailServiceFacade facade, IStorageFactory storageFactory) {
        super(facade);
        this.storageFactory = storageFactory;
    }

    @Override
    public void deleteMessages(final Folder folder, final String ... ids) throws IOException, CancelException {
        new Transaction(this.storageFactory).run(new Transaction.InteractionV0(){

            @Override
            public void run() throws IOException, CancelException {
                TransactionalFacade.this.getWrappedFacade().deleteMessages(folder, ids);
            }
        });
    }

    @Override
    public void deleteMessages(final Folder folder, final ArrayList<IDPSMessage> messages) throws IOException, CancelException {
        new Transaction(this.storageFactory).run(new Transaction.InteractionV0(){

            @Override
            public void run() throws IOException, CancelException {
                TransactionalFacade.this.getWrappedFacade().deleteMessages(folder, messages);
            }
        });
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public boolean testConnection(IProxySettings proxy) throws CancelException, IOException {
        return super.testConnection(proxy);
    }

    @Override
    public boolean verifyAccess(IProxySettings settings, String empref) throws CancelException, IOException {
        return super.verifyAccess(settings, empref);
    }

    @Override
    public boolean verifyAccess(String empref) throws CancelException, IOException {
        return super.verifyAccess(empref);
    }

    @Override
    public IMailMessage getMessage(final Folder folder, final String id) throws IOException, CancelException {
        return new Transaction(this.storageFactory).run(new Transaction.InteractionR0<IMailMessage>(){

            @Override
            public IMailMessage run() throws IOException, CancelException {
                return TransactionalFacade.this.wrap(TransactionalFacade.this.getWrappedFacade().getMessage(folder, id), IMailMessage.class);
            }
        });
    }

    @Override
    public Folder getMessageFolder(final String id) throws IOException, CancelException {
        return new Transaction(this.storageFactory).run(new Transaction.InteractionR0<Folder>(){

            @Override
            public Folder run() throws IOException, CancelException {
                return TransactionalFacade.this.getWrappedFacade().getMessageFolder(id);
            }
        });
    }

    @Override
    public IPAYEMessage getPAYEMessage(final SubmitClass submitClass, final String correlationID) throws IOException, CancelException {
        return new Transaction(this.storageFactory).run(new Transaction.InteractionR0<IPAYEMessage>(){

            @Override
            public IPAYEMessage run() throws IOException, CancelException {
                return TransactionalFacade.this.wrap(TransactionalFacade.this.getWrappedFacade().getPAYEMessage(submitClass, correlationID), IPAYEMessage.class);
            }
        });
    }

    @Override
    public List<IMailMessage> getMessages(final Folder folder, final String ... empref) throws IOException, CancelException {
        return new Transaction(this.storageFactory).run(new Transaction.InteractionR1<List<IMailMessage>, CancelException>(){

            @Override
            public List<IMailMessage> run() throws CancelException, IOException {
                return TransactionalFacade.this.wrap(TransactionalFacade.this.getWrappedFacade().getMessages(folder, empref), IMailMessage.class);
            }
        });
    }

    @Override
    public List<IPAYEMessage> getPAYEMessages(final FormType formType, final int taxYear, final String ... empRef) throws IOException, PluginException, CancelException {
        return new Transaction(this.storageFactory).run(new Transaction.InteractionR2<List<IPAYEMessage>, PluginException, CancelException>(){

            @Override
            public List<IPAYEMessage> run() throws PluginException, CancelException, IOException {
                return TransactionalFacade.this.wrap(TransactionalFacade.this.getWrappedFacade().getPAYEMessages(formType, taxYear, empRef), IPAYEMessage.class);
            }
        });
    }

    @Override
    public IStatusReport getPAYEStatusReport(final SubmitClass submitClass, final Date startDate, final Date endDate) throws IOException, CancelException, SubmitException {
        return new Transaction(this.storageFactory).run(new Transaction.InteractionR2<IStatusReport, SubmitException, CancelException>(){

            @Override
            public IStatusReport run() throws SubmitException, CancelException, IOException {
                return TransactionalFacade.this.getWrappedFacade().getPAYEStatusReport(submitClass, startDate, endDate);
            }
        });
    }

    @Override
    public boolean logon(final IUser user) throws DPSException, RemoteException, IOException, CancelException {
        return new Transaction(this.storageFactory).run(new Transaction.InteractionR3<Boolean, DPSException, RemoteException, CancelException>(){

            @Override
            public Boolean run() throws DPSException, RemoteException, CancelException, IOException {
                return TransactionalFacade.this.getWrappedFacade().logon(user);
            }
        });
    }

    @Override
    public void testPayroll(PayrollServerSpec payrollServer) throws PluginException, CancelException {
        super.testPayroll(payrollServer);
    }

    <T extends IMailMessage> T wrap(T message, Class<T> type) {
        if (IDPSMessage.class.isInstance(message)) {
            message = (IMailMessage)type.cast(new TransactionalDPSMessage((IDPSMessage)IDPSMessage.class.cast(message)).getProxy());
        } else if (IPAYEMessage.class.isInstance(message)) {
            message = (IMailMessage)type.cast(new TransactionalPAYEMessage((IPAYEMessage)IPAYEMessage.class.cast(message)).getProxy());
        }
        return message;
    }

    <T extends IMailMessage> List<T> wrap(List<T> messages, Class<T> type) {
        ListIterator<T> it = messages.listIterator();
        while (it.hasNext()) {
            it.set(this.wrap((IMailMessage)it.next(), type));
        }
        return messages;
    }

    class TransactionalPAYEMessage
    extends PAYEMessageWrapper<IPAYEMessage> {
        public TransactionalPAYEMessage(IPAYEMessage payeMessage) {
            super(payeMessage, IPAYEMessage.class);
        }

        @Override
        public IResponse complete() throws IOException, CancelException, SubmitException {
            return this.runAndCommit(new Transaction.InteractionR2<IResponse, SubmitException, CancelException>(){

                @Override
                public IResponse run() throws SubmitException, CancelException, IOException, CancelException {
                    return ((IPAYEMessage)TransactionalPAYEMessage.this.wrapped).complete();
                }
            });
        }

        private IResponse runAndCommit(Transaction.InteractionR2<IResponse, SubmitException, CancelException> interaction) throws SubmitException, IOException, CancelException {
            AlwaysCommitedWork<IResponse> work = new AlwaysCommitedWork<IResponse>(interaction);
            try {
                IResponse result = new Transaction(TransactionalFacade.this.storageFactory).run(work);
                work.retrowPossibleFailure();
                return result;
            }
            catch (IOException e) {
                work.retrowPossibleFailure();
                throw e;
            }
            catch (CancelException e) {
                work.retrowPossibleFailure();
                throw e;
            }
        }

        @Override
        public IResponse submit() throws IOException, CancelException, SubmitException {
            return this.runAndCommit(new Transaction.InteractionR2<IResponse, SubmitException, CancelException>(){

                @Override
                public IResponse run() throws SubmitException, CancelException, IOException, CancelException {
                    return ((IPAYEMessage)TransactionalPAYEMessage.this.wrapped).submit();
                }
            });
        }

        @Override
        public IResponse validate() throws IOException, CancelException, SubmitException {
            return new Transaction(TransactionalFacade.this.storageFactory).run(new Transaction.InteractionR2<IResponse, CancelException, SubmitException>(){

                @Override
                public IResponse run() throws CancelException, SubmitException, IOException {
                    return ((IPAYEMessage)TransactionalPAYEMessage.this.wrapped).validate();
                }
            });
        }
    }

    static class AlwaysCommitedWork<ReturnType>
    implements Transaction.InteractionR0<ReturnType> {
        final Transaction.InteractionR2<ReturnType, SubmitException, CancelException> wrapped;
        final Throwable[] failure = new Throwable[1];

        public AlwaysCommitedWork(Transaction.InteractionR2<ReturnType, SubmitException, CancelException> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public ReturnType run() throws IOException {
            try {
                return this.wrapped.run();
            }
            catch (IOException e) {
                this.failure[0] = e;
            }
            catch (SubmitException e) {
                this.failure[0] = e;
            }
            catch (CancelException e) {
                this.failure[0] = e;
            }
            return null;
        }

        void retrowPossibleFailure() throws IOException, SubmitException, CancelException {
            if (this.failure[0] != null) {
                if (this.failure[0] instanceof IOException) {
                    throw (IOException)this.failure[0];
                }
                if (this.failure[0] instanceof SubmitException) {
                    throw (SubmitException)this.failure[0];
                }
                if (this.failure[0] instanceof CancelException) {
                    throw (CancelException)this.failure[0];
                }
            }
        }
    }

    class TransactionalDPSMessage
    extends DPSMessageWrapper {
        public TransactionalDPSMessage(IDPSMessage message) {
            super(message);
        }

        @Override
        public void transfer(final boolean firstInBatch) throws IOException, PluginException, CancelException {
            new Transaction(TransactionalFacade.this.storageFactory).run(new Transaction.InteractionV2<CancelException, PluginException>(){

                @Override
                public void run() throws CancelException, PluginException, IOException {
                    ((IDPSMessage)TransactionalDPSMessage.this.wrapped).transfer(firstInBatch);
                }
            });
        }
    }
}

