/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.WrappingFacade;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.IP6P6BMessage;
import com.selima.fbi.core.IP9Message;
import com.selima.fbi.core.IPGL1Message;
import com.selima.fbi.core.IPGL2Message;
import com.selima.fbi.core.ISL1Message;
import com.selima.fbi.core.ISL2Message;
import com.selima.fbi.core.ITrailMessage;
import com.selima.fbi.core.wrapper.DPSMessageWrapper;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class SuperseedCheckFacade
extends WrappingFacade {
    Set<String> idsDeletedFromInbox = new HashSet<String>();

    public SuperseedCheckFacade(IMailServiceFacade facade) {
        super(facade);
    }

    @Override
    public void deleteMessages(Folder folder, String ... ids) throws IOException, CancelException {
        super.deleteMessages(folder, ids);
        if (folder == Folder.INBOX) {
            for (String id : ids) {
                this.idsDeletedFromInbox.add(id);
            }
        }
    }

    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... empref) throws IOException, CancelException {
        List<IMailMessage> result = super.getMessages(folder, empref);
        if (folder == Folder.INBOX) {
            TrailMessage trailMessage;
            this.idsDeletedFromInbox.clear();
            ListIterator<IMailMessage> it = result.listIterator();
            while (it.hasNext()) {
                IMailMessage message = it.next();
                TrailId trailId = this.trailId(message);
                if (trailId == null) continue;
                it.set(new TrailMessage((IDPSMessage)message, trailId));
            }
            HashMap<TrailId, LinkedList<TrailMessage>> trailMap = new HashMap<TrailId, LinkedList<TrailMessage>>(result.size());
            TrailComparator comparator = new TrailComparator();
            block1: for (IMailMessage message : result) {
                if (!(message instanceof TrailMessage)) continue;
                trailMessage = (TrailMessage)message;
                TrailId trailId = trailMessage.getTrailId();
                LinkedList<TrailMessage> list = (LinkedList<TrailMessage>)trailMap.get(trailId);
                if (list == null) {
                    list = new LinkedList<TrailMessage>(Arrays.asList(trailMessage));
                    trailMap.put(trailId, list);
                    continue;
                }
                ListIterator<TrailMessage> it2 = list.listIterator();
                while (it2.hasNext()) {
                    if (comparator.compare(it2.next(), trailMessage) <= 0) continue;
                    it2.previous();
                    it2.add(trailMessage);
                    continue block1;
                }
                list.add(trailMessage);
            }
            for (List list : trailMap.values()) {
                LinkedList<String> ids = new LinkedList<String>();
                for (TrailMessage message : list) {
                    message.setTrailContent(ids);
                    ids.add(message.getStoreId());
                }
            }
            ListIterator<IMailMessage> it3 = result.listIterator();
            while (it3.hasNext()) {
                IMailMessage message;
                message = it3.next();
                if (!(message instanceof TrailMessage)) continue;
                trailMessage = (TrailMessage)message;
                it3.set((IMailMessage)trailMessage.getProxy());
            }
        }
        return result;
    }

    TrailId trailId(IMailMessage message) {
        switch (message.getFormType()) {
            case P6: 
            case P6B: {
                return new TrailId(TrailType.P6_P9, ((IP6P6BMessage)message).getNino());
            }
            case P9: {
                return new TrailId(TrailType.P6_P9, ((IP9Message)message).getNino());
            }
            case SL1: {
                return new TrailId(TrailType.SL1_SL2, ((ISL1Message)message).getNino());
            }
            case SL2: {
                return new TrailId(TrailType.SL1_SL2, ((ISL2Message)message).getNino());
            }
            case PGL1: {
                return new TrailId(TrailType.PGL1_PGL2, ((IPGL1Message)message).getNino());
            }
            case PGL2: {
                return new TrailId(TrailType.PGL1_PGL2, ((IPGL2Message)message).getNino());
            }
        }
        return null;
    }

    static class TrailId {
        final TrailType type;
        final String nino;

        TrailId(TrailType type, String nino) {
            this.type = type;
            this.nino = nino;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TrailId) {
                TrailId trailId = (TrailId)obj;
                return this.type == trailId.type && this.nino.equals(trailId.nino);
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode() + this.nino.hashCode();
        }
    }

    static enum TrailType {
        P6_P9,
        SL1_SL2,
        PGL1_PGL2;

    }

    class TrailMessage
    extends DPSMessageWrapper
    implements ITrailMessage {
        List<String> preceedingIds;
        TrailId trailId;

        TrailMessage(IDPSMessage message, TrailId trailId) {
            super(message);
            this.trailId = trailId;
        }

        TrailId getTrailId() {
            return this.trailId;
        }

        Date getEffectiveDate() {
            if (this.wrapped instanceof IP6P6BMessage) {
                return ((IP6P6BMessage)this.wrapped).getEffectiveDate();
            }
            if (this.wrapped instanceof IP9Message) {
                return ((IP9Message)this.wrapped).getEffectiveDate();
            }
            if (this.wrapped instanceof ISL1Message) {
                return ((ISL1Message)this.wrapped).getStartDate();
            }
            if (this.wrapped instanceof ISL2Message) {
                return ((ISL2Message)this.wrapped).getStopDate();
            }
            if (this.wrapped instanceof IPGL1Message) {
                return ((IPGL1Message)this.wrapped).getStartDate();
            }
            if (this.wrapped instanceof IPGL2Message) {
                return ((IPGL2Message)this.wrapped).getStopDate();
            }
            return null;
        }

        void setTrailContent(List<String> trail) {
            this.preceedingIds = new LinkedList<String>(trail);
        }

        @Override
        public boolean isTransferrable() {
            return super.isTransferrable() && this.getPreceedingIds().isEmpty();
        }

        @Override
        public List<String> getPreceedingIds() {
            this.preceedingIds.removeAll(SuperseedCheckFacade.this.idsDeletedFromInbox);
            return Collections.unmodifiableList(this.preceedingIds);
        }
    }

    class TrailComparator
    implements Comparator<TrailMessage> {
        TrailComparator() {
        }

        @Override
        public int compare(TrailMessage o1, TrailMessage o2) {
            try {
                Date issueDate2;
                Date effectiveDate1 = o1.getEffectiveDate();
                Date effectiveDate2 = o2.getEffectiveDate();
                if (effectiveDate1.before(effectiveDate2)) {
                    return -1;
                }
                if (effectiveDate1.after(effectiveDate2)) {
                    return 1;
                }
                Date issueDate1 = o1.getIssueDate();
                if (issueDate1.before(issueDate2 = o2.getIssueDate())) {
                    return -1;
                }
                if (issueDate1.after(issueDate2)) {
                    return 1;
                }
                return 0;
            }
            catch (NullPointerException e) {
                LogAPI.logSevere((String)("Problem comparing " + o1.getStoreId() + " and " + o2.getStoreId()), (Throwable)e);
                return 0;
            }
        }
    }
}

