/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.AbstractSimpleFolderFacade;
import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.FormType;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.PAYESubmissionDetails;
import com.selima.fbi.core.SubmitClass;
import com.selima.fbi.core.response.ErrorResponse;
import com.selima.fbi.core.response.IErrorResponse;
import com.selima.fbi.core.response.IResponse;
import com.selima.fbi.core.response.IStorableResponse;
import com.selima.fbi.core.response.ISuccessResponse;
import com.selima.fbi.core.response.SuccessResponse;
import com.selima.fbi.core.wrapper.ExtendedPAYEMessageWrapper;
import com.selima.fbi.core.wrapper.PAYEMessageWrapper;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.submission.SubmitException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;

public class SentBoxFacade
extends AbstractSimpleFolderFacade<IPAYEMessage> {
    PAYEMessageStorage payeMessageStorage;

    public SentBoxFacade(IMailServiceFacade facade, IStorageFactory storageFactory) throws IOException {
        super(facade, storageFactory, IPAYEMessage.class, Folder.SENT);
        this.storageFactory = storageFactory;
        this.payeMessageStorage = new PAYEMessageStorage(storageFactory);
    }

    @Override
    public IPAYEMessage getPAYEMessage(SubmitClass submitClass, String correlationID) throws IOException, CancelException {
        if (this.getCurrentUser() == null) {
            throw new IllegalStateException("User must be logged in");
        }
        for (String empRef : this.getCurrentUser().getEmpRef()) {
            for (String id : this.getDetailsStorage(empRef).getIds()) {
                PAYESubmissionDetails details = this.getDetailsStorage(empRef).load(id);
                if (!correlationID.equals(details.correlationId) || submitClass != details.submitClass) continue;
                return this.getStorage(empRef).load(id);
            }
        }
        return super.getPAYEMessage(submitClass, correlationID);
    }

    @Override
    public List<IPAYEMessage> getPAYEMessages(FormType formType, int taxYear, String ... empRef) throws IOException, PluginException, CancelException {
        List<IPAYEMessage> result = super.getPAYEMessages(formType, taxYear, empRef);
        ListIterator<IPAYEMessage> it = result.listIterator();
        while (it.hasNext()) {
            it.set((IPAYEMessage)new SendablePAYEMessage(it.next()).getProxy());
        }
        return result;
    }

    protected IStorage<PAYESubmissionDetails> getDetailsStorage(String empRef) throws IOException, CancelException {
        return this.storageFactory.getStorage("paye-details", empRef, PAYESubmissionDetails.class);
    }

    @Override
    protected IStorage<IPAYEMessage> getStorage(String empRef) throws IOException {
        this.payeMessageStorage.setInnerSpace(empRef);
        return this.payeMessageStorage;
    }

    class SendablePAYEMessage
    extends PAYEMessageWrapper<IPAYEMessage> {
        SendablePAYEMessage(IPAYEMessage payeMessage) {
            super(payeMessage, IPAYEMessage.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IResponse submit() throws IOException, CancelException, SubmitException {
            String nextId = this.getNextId();
            String original = this.getCorrelationId();
            SentBoxPAYEMessage sentBoxRecord = new SentBoxPAYEMessage(nextId, this);
            sentBoxRecord.setCorrelationId(null);
            sentBoxRecord.setErrorMessage("Submission died unexpectedly before getting Correlation ID");
            sentBoxRecord.setIssueDate(new Date());
            SentBoxFacade.this.getStorage(this.getStoreSpace()).store((IPAYEMessage)sentBoxRecord.getProxy());
            try {
                IResponse iResponse = super.submit();
                return iResponse;
            }
            finally {
                if (this.getCorrelationId() != null && !this.getCorrelationId().equals(original)) {
                    sentBoxRecord = new SentBoxPAYEMessage(nextId, this);
                    SentBoxFacade.this.getStorage(this.getStoreSpace()).store((IPAYEMessage)sentBoxRecord.getProxy());
                }
            }
        }

        String getNextId() throws IOException, CancelException {
            HashSet<String> existingIds = new HashSet<String>(Arrays.asList(SentBoxFacade.this.getStorage(this.getStoreSpace()).getIds()));
            int id = 1;
            while (existingIds.contains(this.getStoreSpace() + '-' + String.valueOf(id))) {
                ++id;
            }
            return this.getStoreSpace() + '-' + id;
        }
    }

    static class SentBoxPAYEMessage
    extends ExtendedPAYEMessageWrapper {
        private String storeId;

        public SentBoxPAYEMessage(String storeId, IPAYEMessage payeMessage, PAYESubmissionDetails details, IStorableResponse response) {
            super(payeMessage);
            this.storeId = storeId;
            this.issueDate = details.issueDate;
            this.errorMessage = details.errorMessage;
            this.correlationId = details.correlationId;
            if (response instanceof ISuccessResponse) {
                this.successResponse = (ISuccessResponse)((Object)response);
            }
            if (response instanceof IErrorResponse) {
                this.errorResponse = (IErrorResponse)((Object)response);
            }
        }

        public SentBoxPAYEMessage(String storeId, IPAYEMessage payeMessage) {
            super(payeMessage);
            this.storeId = storeId;
            this.issueDate = payeMessage.getIssueDate();
            this.errorMessage = payeMessage.getErrorMessage();
            this.correlationId = payeMessage.getCorrelationId();
            if (payeMessage.isSuccessful()) {
                this.successResponse = new SuccessResponse(payeMessage.getSuccessResponse(), storeId, this.getStoreSpace());
            }
            if (payeMessage.isFailed()) {
                this.errorResponse = new ErrorResponse(payeMessage.getErrorResponse(), storeId, this.getStoreSpace());
            }
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public void setCorrelationId(String correlationId) {
            this.correlationId = correlationId;
        }

        public void setIssueDate(Date issueDate) {
            this.issueDate = issueDate;
        }

        @Override
        public String getStoreId() {
            return this.storeId;
        }
    }

    static class PAYEMessageStorage
    implements IStorage<IPAYEMessage> {
        IStorageFactory storageFactory;
        String innerSpace;

        PAYEMessageStorage(IStorageFactory storageFactory) {
            this.storageFactory = storageFactory;
        }

        IStorage<IPAYEMessage> getBodyStorage(String empRef) throws IOException, CancelException {
            return this.storageFactory.getStorage("paye-message", empRef, IPAYEMessage.class);
        }

        IStorage<IStorableResponse> getResponseStorage(String empRef) throws IOException, CancelException {
            return this.storageFactory.getStorage("paye-response", empRef, IStorableResponse.class);
        }

        IStorage<PAYESubmissionDetails> getDetailsStorage(String empRef) throws IOException, CancelException {
            return this.storageFactory.getStorage("paye-details", empRef, PAYESubmissionDetails.class);
        }

        @Override
        public boolean contains(String storeId) throws IOException, CancelException {
            return this.getBodyStorage(this.innerSpace).contains(storeId);
        }

        @Override
        public void delete(String storeId) throws IOException, CancelException {
            this.getBodyStorage(this.innerSpace).delete(storeId);
            this.getDetailsStorage(this.innerSpace).delete(storeId);
            if (this.getResponseStorage(storeId).contains(storeId)) {
                this.getResponseStorage(this.innerSpace).delete(storeId);
            }
        }

        @Override
        public String[] getIds() throws IOException, CancelException {
            return this.getBodyStorage(this.innerSpace).getIds();
        }

        @Override
        public Class<IPAYEMessage> getType() {
            return IPAYEMessage.class;
        }

        @Override
        public IPAYEMessage load(String storeId) throws IOException, CancelException {
            IStorableResponse response;
            IPAYEMessage bodyMessage = this.getBodyStorage(this.innerSpace).load(storeId);
            if (this.getResponseStorage(this.innerSpace).contains(storeId)) {
                response = this.getResponseStorage(this.innerSpace).load(storeId);
                response.setStoreSpace(bodyMessage.getStoreSpace());
                response.setStoreId(bodyMessage.getStoreId());
            } else {
                response = null;
            }
            PAYESubmissionDetails details = this.getDetailsStorage(this.innerSpace).load(storeId);
            return (IPAYEMessage)new SentBoxPAYEMessage(storeId, bodyMessage, details, response).getProxy();
        }

        @Override
        public void setInnerSpace(String space) {
            this.innerSpace = space;
        }

        @Override
        public void store(IPAYEMessage payeMessage) throws IOException, CancelException {
            this.getBodyStorage(this.innerSpace).store(payeMessage);
            this.getDetailsStorage(this.innerSpace).store(new PAYESubmissionDetails(payeMessage.getStoreSpace(), payeMessage.getStoreId(), payeMessage.getIssueDate(), payeMessage.getCorrelationId(), payeMessage.getErrorMessage(), payeMessage.getFormType().getSubmitClass(false)));
            if (payeMessage.isSuccessful()) {
                this.getResponseStorage(this.innerSpace).store((IStorableResponse)((Object)payeMessage.getSuccessResponse()));
            } else if (payeMessage.isFailed()) {
                this.getResponseStorage(this.innerSpace).store((IStorableResponse)((Object)payeMessage.getErrorResponse()));
            } else if (this.getResponseStorage(this.innerSpace).contains(payeMessage.getStoreId())) {
                this.getResponseStorage(this.innerSpace).delete(payeMessage.getStoreId());
            }
        }
    }
}

