/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelabilityState;
import com.selima.fbi.PAYEServiceListener;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.SubmitClass;
import com.selima.fbi.submission.ISubmissionProcessor;
import com.selima.fbi.submission.ISubmitResult;
import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.submission.core.body.IStatusReport;
import java.io.IOException;
import java.util.Date;

class SafetySubmissionProcessor
implements ISubmissionProcessor {
    final CancelabilityState cancelability;
    final ISubmissionProcessor wrapped;

    public SafetySubmissionProcessor(ISubmissionProcessor wrapped, CancelabilityState cancelability) {
        this.cancelability = cancelability;
        this.wrapped = wrapped;
    }

    @Override
    public void addSubmitListener(PAYEServiceListener listener) {
        this.wrapped.addSubmitListener(listener);
    }

    @Override
    public void cancel() {
        this.wrapped.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISubmitResult complete(IPAYEMessage message, SubmitClass submitClass) throws SubmitException, IOException {
        try {
            ISubmitResult iSubmitResult = this.wrapped.complete(message, submitClass);
            return iSubmitResult;
        }
        finally {
            this.cancelability.setSafe(false);
        }
    }

    @Override
    public IStatusReport getStatusReport(String submitClass, Date from, Date to) throws IOException, SubmitException {
        return this.wrapped.getStatusReport(submitClass, from, to);
    }

    @Override
    public boolean isActive() {
        return this.wrapped.isActive();
    }

    @Override
    public void removeSubmitListener(PAYEServiceListener listener) {
        this.wrapped.removeSubmitListener(listener);
    }

    @Override
    public ISubmitResult submit(IPAYEMessage data) throws SubmitException, IOException {
        try {
            ISubmitResult iSubmitResult = this.wrapped.submit(data);
            return iSubmitResult;
        }
        finally {
            this.cancelability.setSafe(false);
        }
    }

    @Override
    public ISubmitResult validate(IPAYEMessage data) throws SubmitException, IOException {
        return this.wrapped.validate(data);
    }
}

