/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import java.io.IOException;

public class ProxySettingsException
extends IOException {
    String html;

    ProxySettingsException(Throwable e) {
        super(ProxySettingsException.parseMessage(e.getMessage()), e);
        this.html = this.parseHtml(e.getMessage());
    }

    public ProxySettingsException(String targetUrl, String proxyHost, String proxyPort, String proxyUser, String statusLine) {
        super(ProxySettingsException.buildMessage(targetUrl, proxyHost, proxyPort, proxyUser));
        this.html = "<html>" + statusLine + "</html>";
    }

    public String getHtml() {
        return this.html;
    }

    public static void checkProxyError(Exception e) throws ProxySettingsException {
        for (Throwable t = e; t != null; t = t.getCause()) {
            if (!(t instanceof IOException) || e.getMessage() == null || !e.getMessage().contains("Unable to tunnel through")) continue;
            throw new ProxySettingsException(t);
        }
    }

    private String parseHtml(String message) {
        String[] delimiters;
        for (String delimiter : delimiters = new String[]{"<!DOCTYPE", "<HTML", "<html"}) {
            if (!message.contains(delimiter)) continue;
            message = message.substring(message.indexOf(delimiter));
        }
        return message;
    }

    private static String buildMessage(String urlString, String proxyHost, String proxyPort, String proxyUser) {
        return "Proxy server error. Unable to tunnel to [<b>" + urlString + "</b>] through proxy server [<b>" + proxyHost + (proxyPort == null ? "" : ":" + String.valueOf(proxyPort)) + "</b>] as proxy user [<b>" + proxyUser + "</b>].<p>Ask your network administrator to unblock the route and / or change your proxy settings.";
    }

    private static String parseMessage(String message) {
        String[] delimiters;
        for (String delimiter : delimiters = new String[]{"<!DOCTYPE", "<HTML", "<html"}) {
            if (!message.contains(delimiter)) continue;
            message = message.substring(message.indexOf("Unable to tunnel through"), message.indexOf(delimiter));
        }
        return message;
    }
}

