/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.DPSServiceListener;
import com.selima.fbi.Folder;
import com.selima.fbi.FormType;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.WrappingFacade;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.IP6P6BMessage;
import com.selima.fbi.core.IP9Message;
import com.selima.fbi.core.IPayrollCheckedMessage;
import com.selima.fbi.core.IPayrollCheckedP6P6BMessage;
import com.selima.fbi.core.IPayrollCheckedP9Message;
import com.selima.fbi.core.wrapper.DPSMessageWrapper;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.user.IReferenceManager;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class PayrollCheckFacade
extends WrappingFacade {
    IReferenceManager referenceManager;
    volatile boolean running;
    volatile boolean cancel;
    static int transferNumber;
    EventBroadcast<DPSServiceListener> listeners = EventBroadcastFactory.createEventBroadcast(DPSServiceListener.class);

    public PayrollCheckFacade(IMailServiceFacade facade, IReferenceManager referenceManager) {
        super(facade);
        this.referenceManager = referenceManager;
    }

    @Override
    public IMailMessage getMessage(Folder folder, String id) throws IOException, CancelException {
        IMailMessage result = super.getMessage(folder, id);
        if (result != null && folder == Folder.INBOX) {
            result = this.wrap(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... empref) throws IOException, CancelException {
        List<IMailMessage> result = super.getMessages(folder, empref);
        if (folder == Folder.INBOX) {
            try {
                assert (IDPSMessage.class.isAssignableFrom(folder.contentType()));
                this.running = true;
                int numOfChecked = 0;
                for (IMailMessage message : result) {
                    if (!Arrays.asList(FormType.P6, FormType.P6B, FormType.P9).contains((Object)message.getFormType())) continue;
                    ++numOfChecked;
                }
                ((DPSServiceListener)this.listeners.getListener()).payrollCheckStarted(numOfChecked);
                ListIterator<IMailMessage> it = result.listIterator();
                while (it.hasNext()) {
                    if (this.cancel) {
                        throw new CancelException();
                    }
                    it.set(this.wrap((IDPSMessage)it.next()));
                }
                HashSet<String> taxReferences = new HashSet<String>();
                ListIterator<IMailMessage> it2 = result.listIterator();
                while (it2.hasNext()) {
                    if (this.cancel) {
                        throw new CancelException();
                    }
                    this.check(it2.next(), taxReferences);
                }
            }
            finally {
                this.running = false;
                this.cancel = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(IMailMessage message, Set<String> taxReferences) throws CancelException {
        if (message instanceof IPayrollCheckedMessage) {
            String taxRef = message.getEmpRef();
            try {
                ((IPayrollCheckedMessage)message).checkInPayroll(!taxReferences.contains(taxRef));
            }
            catch (PluginException e) {
                LogAPI.logSevere((Throwable)e);
                Throwable throwable = e;
                while (throwable.getCause() != null) {
                    throwable = throwable.getCause();
                }
                ((IPayrollCheckedMessage)message).setPayrollWarningMessage("Payroll Check Failed: " + throwable.getMessage());
            }
            finally {
                taxReferences.add(taxRef);
            }
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.running) {
            this.cancel = this.running;
            this.getCurrentUser().getPayrollPlugin().cancel();
        }
    }

    @Override
    public void addDPSServiceListener(DPSServiceListener listener) {
        this.listeners.addListener((Object)listener);
        super.addDPSServiceListener(listener);
    }

    @Override
    public void removeDPSServiceListener(DPSServiceListener listener) {
        this.listeners.removeListener((Object)listener);
        super.removeDPSServiceListener(listener);
    }

    IMailMessage wrap(IMailMessage message) {
        if (message instanceof IP6P6BMessage || message instanceof IP9Message) {
            if (message instanceof IP6P6BMessage) {
                return new PayrollCheckingP6Message((IP6P6BMessage)message).getProxy();
            }
            if (message instanceof IP9Message) {
                return new PayrollCheckingP9Message((IP9Message)message).getProxy();
            }
        }
        return message;
    }

    class PayrollCheckingP6Message
    extends PayrollCheckingMessage
    implements IPayrollCheckedP6P6BMessage {
        String payrollTaxCode;
        String payrollTaxRegime;
        boolean payrollWeek1Month1Indicator;
        Number payrollTotalPreviousPay;
        Number payrollTotalPreviousTax;

        PayrollCheckingP6Message(IP6P6BMessage message) {
            super(message);
        }

        IP6P6BMessage wrapped() {
            return (IP6P6BMessage)this.wrapped;
        }

        @Override
        public String getPayrollTaxCode() {
            return this.payrollTaxCode;
        }

        @Override
        public Number getPayrollTotalPrevousPay() {
            return this.payrollTotalPreviousPay;
        }

        @Override
        public Number getPayrollTotalPrevousTax() {
            return this.payrollTotalPreviousTax;
        }

        @Override
        public boolean isPayrollWeek1Month1Indicator() {
            return this.payrollWeek1Month1Indicator;
        }

        @Override
        public void setPayrollTaxCode(String taxCode) {
            this.payrollTaxCode = taxCode;
        }

        @Override
        public void setPayrollTotalPreviousPay(Number number) {
            this.payrollTotalPreviousPay = number;
        }

        @Override
        public void setPayrollTotalPreviousTax(Number number) {
            this.payrollTotalPreviousTax = number;
        }

        @Override
        public void setPayrollWeek1Month1Indicator(boolean indicator) {
            this.payrollWeek1Month1Indicator = indicator;
        }

        @Override
        public String getPayrollTaxRegime() {
            return this.payrollTaxRegime;
        }

        @Override
        public void setPayrollTaxRegime(String payrollTaxRegime) {
            this.payrollTaxRegime = payrollTaxRegime;
        }

        @Override
        public Date getEffectiveDate() {
            return this.wrapped().getEffectiveDate();
        }

        @Override
        public List<String> getForename() {
            return this.wrapped().getForename();
        }

        @Override
        public String getNino() {
            return this.wrapped().getNino();
        }

        @Override
        public String getSurname() {
            return this.wrapped().getSurname();
        }

        @Override
        public String getTaxCode() {
            return this.wrapped().getTaxCode();
        }

        @Override
        public Number getTotalPreviousPay() {
            return this.wrapped().getTotalPreviousPay();
        }

        @Override
        public Number getTotalPreviousTax() {
            return this.wrapped().getTotalPreviousTax();
        }

        @Override
        public boolean getWeek1Month1Indicator() {
            return this.wrapped().getWeek1Month1Indicator();
        }

        @Override
        public String getWorksNumber() {
            return this.wrapped().getWorksNumber();
        }

        @Override
        public String getTaxRegime() {
            return this.wrapped().getTaxRegime();
        }
    }

    class PayrollCheckingP9Message
    extends PayrollCheckingMessage
    implements IPayrollCheckedP9Message {
        private String payrollTaxCode;
        private String payrollTaxRegime;
        private boolean payrollWeek1Month1Indicator;

        PayrollCheckingP9Message(IP9Message message) {
            super(message);
        }

        IP9Message wrapped() {
            return (IP9Message)this.wrapped;
        }

        @Override
        public String getPayrollTaxCode() {
            return this.payrollTaxCode;
        }

        @Override
        public void setPayrollTaxCode(String taxCode) {
            this.payrollTaxCode = taxCode;
        }

        @Override
        public boolean isPayrollWeek1Month1Indicator() {
            return this.payrollWeek1Month1Indicator;
        }

        @Override
        public void setPayrollWeek1Month1Indicator(boolean indicator) {
            this.payrollWeek1Month1Indicator = indicator;
        }

        @Override
        public Date getEffectiveDate() {
            return this.wrapped().getEffectiveDate();
        }

        @Override
        public List<String> getForename() {
            return this.wrapped().getForename();
        }

        @Override
        public String getNino() {
            return this.wrapped().getNino();
        }

        @Override
        public String getSurname() {
            return this.wrapped().getSurname();
        }

        @Override
        public String getTaxCode() {
            return this.wrapped().getTaxCode();
        }

        @Override
        public boolean getWeek1Month1Indicator() {
            return this.wrapped().getWeek1Month1Indicator();
        }

        @Override
        public String getWorksNumber() {
            return this.wrapped().getWorksNumber();
        }

        @Override
        public String getTaxRegime() {
            return this.wrapped().getTaxRegime();
        }

        @Override
        public String getPayrollTaxRegime() {
            return this.payrollTaxRegime;
        }

        @Override
        public void setPayrollTaxRegime(String payrollTaxRegime) {
            this.payrollTaxRegime = payrollTaxRegime;
        }
    }

    class PayrollCheckingMessage
    extends DPSMessageWrapper
    implements IPayrollCheckedMessage {
        private int checkNumber;
        private String payrollWarningMessage;

        PayrollCheckingMessage(IDPSMessage message) {
            super(message);
        }

        @Override
        public String getPayrollWarningMessage() {
            return this.payrollWarningMessage;
        }

        @Override
        public void setPayrollWarningMessage(String warning) {
            this.payrollWarningMessage = warning;
        }

        @Override
        public void transfer(boolean firstInBatch) throws IOException, PluginException, CancelException {
            super.transfer(firstInBatch);
            ++transferNumber;
        }

        @Override
        public void checkInPayroll(boolean firstInBatch) throws CancelException, PluginException {
            PayrollCheckFacade.this.running = true;
            try {
                this.checkNumber = transferNumber;
                PayrollServerSpec payrollServer = PayrollCheckFacade.this.referenceManager.getPayrollServer(this.getEmpRef());
                if (payrollServer.isSufficient()) {
                    PayrollCheckFacade.this.getCurrentUser().getPayrollPlugin().checkDPSMessage(payrollServer, this, firstInBatch);
                }
            }
            finally {
                PayrollCheckFacade.this.running = false;
                ((DPSServiceListener)PayrollCheckFacade.this.listeners.getListener()).payrollChecked(this.getSubject());
            }
        }

        @Override
        public boolean isUptodate() {
            return transferNumber == this.checkNumber;
        }
    }
}

