/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.AbstractSubmissionFacade;
import com.selima.fbi.CancelException;
import com.selima.fbi.CancelabilityState;
import com.selima.fbi.FormType;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.NetworkTracker;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.response.IErrorResponse;
import com.selima.fbi.core.response.IResponse;
import com.selima.fbi.core.response.ISuccessResponse;
import com.selima.fbi.core.wrapper.ExtendedPAYEMessageWrapper;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.service.IMailService;
import com.selima.fbi.submission.ISubmitResult;
import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.submission.SubmitStoppedException;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;

public class PAYESendingFacade
extends AbstractSubmissionFacade {
    public PAYESendingFacade(IMailServiceFacade facade, IMailService service, NetworkTracker networkTracker, CancelabilityState cancelability) {
        super(facade, service, networkTracker, cancelability);
    }

    protected PAYESendingFacade(IMailServiceFacade facade, IMailService service) {
        this(facade, service, new NetworkTracker(), new CancelabilityState());
    }

    @Override
    public List<IPAYEMessage> getPAYEMessages(FormType formType, int taxYear, String ... empRef) throws IOException, PluginException, CancelException {
        List<IPAYEMessage> result = super.getPAYEMessages(formType, taxYear, empRef);
        ListIterator<IPAYEMessage> it = result.listIterator();
        while (it.hasNext()) {
            it.set((IPAYEMessage)new SendablePAYEMessage(it.next()).getProxy());
        }
        return result;
    }

    class SendablePAYEMessage
    extends ExtendedPAYEMessageWrapper {
        SendablePAYEMessage(IPAYEMessage payeMessage) {
            super(payeMessage);
        }

        @Override
        public IResponse submit() throws IOException, CancelException, SubmitException {
            try {
                ISubmitResult result = PAYESendingFacade.this.submissionProcessor.submit(this);
                this.issueDate = result.getIssueDate();
                this.correlationId = result.getCorrelationID();
                IResponse response = result.getResponse();
                if (response instanceof ISuccessResponse) {
                    this.successResponse = (ISuccessResponse)response;
                }
                if (response instanceof IErrorResponse) {
                    this.errorResponse = (IErrorResponse)response;
                }
                return response;
            }
            catch (SubmitException e) {
                if (e.getCorrelationID() != null) {
                    this.correlationId = e.getCorrelationID();
                    this.issueDate = e.getIssueDate();
                    this.errorMessage = e.getMessage();
                }
                if (e instanceof SubmitStoppedException) {
                    throw new CancelException();
                }
                throw e;
            }
            catch (IOException e) {
                this.errorMessage = e.getMessage();
                throw e;
            }
        }

        @Override
        public IResponse validate() throws IOException, CancelException, SubmitException {
            try {
                return PAYESendingFacade.this.submissionProcessor.validate(this).getResponse();
            }
            catch (SubmitStoppedException e) {
                throw new CancelException();
            }
        }
    }
}

