/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.framework.util.logging.LogAPI;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;

public class MailServiceConfig {
    private static final String RESOURCE_FILE = "fbi.properties";
    private static Properties properties = new Properties();
    private static ClassLoader configClassLoader;
    private static String loggingProperties;
    private static File baseDir;
    private static String DEFAULT_JAVA_UTIL_LOGGING_CONFIG;
    private static String customJavaUtilLoggingConfig;

    public static File getBaseDir() {
        return baseDir;
    }

    public static void setCustomJavaUtilLoggingConfig(String configFile) {
        customJavaUtilLoggingConfig = configFile;
    }

    public static void setBaseDir(File dir) {
        Preferences prefs;
        Preferences preferences = prefs = "System".equals(Preferences.systemNodeForPackage(MailServiceConfig.class).get("store.node", "System")) ? Preferences.systemNodeForPackage(MailServiceConfig.class) : Preferences.userNodeForPackage(MailServiceConfig.class);
        if (dir != null) {
            baseDir = dir;
            prefs.put(MailServiceConfig.baseDirPreferenceKey(), dir.getAbsolutePath());
        } else {
            baseDir = new File(MailServiceConfig.defaultBaseDir());
            prefs.remove(MailServiceConfig.baseDirPreferenceKey());
        }
        loggingProperties = null;
    }

    public static String getInitParameter(String name) {
        return properties.getProperty(name);
    }

    public static String getInitParameter(String name, String defaultValue) {
        return properties.getProperty(name, defaultValue);
    }

    public static Map<String, String> getInitParamaters() {
        return Collections.unmodifiableMap(properties);
    }

    public static InputStream getResourceAsStream(String resource) {
        return configClassLoader.getResourceAsStream(resource);
    }

    public static URL getResource(String resource) {
        return configClassLoader.getResource(resource);
    }

    public static URL getLibrariesDescriptionURL() {
        return MailServiceConfig.getLibResourceURL("libraries.description.txt");
    }

    public static URL getLicenceURL(String libraryFileName) {
        return MailServiceConfig.getLibResourceURL(libraryFileName + ".license.txt");
    }

    private static URL getLibResourceURL(String fileName) {
        URL url = configClassLoader.getResource("lib/" + fileName);
        if (url == null) {
            try {
                URLClassLoader libClassLoader = new URLClassLoader(new URL[]{new URL("file", "", "lib/")});
                url = libClassLoader.getResource(fileName);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return url;
    }

    public static InputStream getLoggingProperties() {
        try {
            if (loggingProperties == null) {
                BufferedInputStream bufferedInputStream;
                boolean useDefaultConfig = true;
                if (customJavaUtilLoggingConfig != null && !"".equals(customJavaUtilLoggingConfig)) {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(customJavaUtilLoggingConfig));
                    useDefaultConfig = false;
                } else {
                    bufferedInputStream = new BufferedInputStream(MailServiceConfig.getResourceAsStream(DEFAULT_JAVA_UTIL_LOGGING_CONFIG));
                }
                InputStreamReader reader = new InputStreamReader((InputStream)bufferedInputStream, "ISO-8859-1");
                StringBuilder builder = new StringBuilder();
                int c = reader.read();
                while (c != -1) {
                    builder.append((char)c);
                    c = reader.read();
                }
                if (useDefaultConfig) {
                    builder.append("\n#Generated log-file section\njava.util.logging.FileHandler.pattern=");
                    String path = baseDir.getAbsolutePath();
                    if (path.startsWith("\\\\")) {
                        path = path.substring(2);
                        builder.append("\\\\\\\\");
                    }
                    builder.append(path.replace(File.separatorChar, '/'));
                    builder.append('/').append("log.txt\n");
                }
                loggingProperties = builder.toString();
            }
            return new ByteArrayInputStream(loggingProperties.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            if (loggingProperties != null) {
                LogAPI.logSevere((Throwable)e);
            } else {
                e.printStackTrace();
            }
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    static String defaultBaseDir() {
        String folder = MailServiceConfig.isDevelopmentVersion() ? "Selima-FBI-Dev" : "Selima-FBI";
        String allUsersProfile = System.getenv("ALLUSERSPROFILE");
        String currentProfile = System.getenv("USERPROFILE");
        String appData = System.getenv("APPDATA");
        if (allUsersProfile == null || currentProfile == null) {
            return "." + File.separator + folder;
        }
        if (appData == null) {
            appData = currentProfile + File.separator + "Application Data";
        }
        if (appData.contains(currentProfile)) {
            return allUsersProfile + appData.substring(currentProfile.length()) + File.separator + folder;
        }
        return appData + File.separator + folder;
    }

    public static boolean isDevelopmentVersion() {
        String release = MailServiceConfig.getInitParameter("release.name");
        return release == null || "@release.name@".equals(release) || release.startsWith("Development");
    }

    static String baseDirPreferenceKey() {
        return MailServiceConfig.isDevelopmentVersion() ? "baseDirDev" : "baseDir";
    }

    static {
        DEFAULT_JAVA_UTIL_LOGGING_CONFIG = "logging.properties";
        configClassLoader = MailServiceConfig.class.getClassLoader();
        InputStream is = configClassLoader.getResourceAsStream(RESOURCE_FILE);
        if (is == null) {
            try {
                configClassLoader = new URLClassLoader(new URL[]{new URL("file", "", "config/")});
                is = configClassLoader.getResourceAsStream(RESOURCE_FILE);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        if (is == null) {
            System.err.println("Configuration file is not available: fbi.properties");
        } else {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                System.err.println("Read file error: fbi.properties");
                e.printStackTrace();
            }
        }
        Preferences prefs = "System".equals(Preferences.systemNodeForPackage(MailServiceConfig.class).get("store.node", "System")) ? Preferences.systemNodeForPackage(MailServiceConfig.class) : Preferences.userNodeForPackage(MailServiceConfig.class);
        baseDir = new File(prefs.get(MailServiceConfig.baseDirPreferenceKey(), MailServiceConfig.defaultBaseDir()));
    }
}

