/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.AbstractFolderFacade;
import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.service.DPSErrorEnum;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.user.IUser;
import com.selima.fbi.user.IUserManager;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class InboxFacade
extends AbstractFolderFacade<IDPSMessage> {
    IUser offlineUser;
    IUserManager userManager;
    private volatile boolean cancel;
    private volatile boolean cancelable;

    public InboxFacade(IMailServiceFacade facade, IUserManager manager, IStorageFactory storageFactory) {
        super(facade, storageFactory);
        this.userManager = manager;
    }

    @Override
    public boolean logon(IUser user) throws DPSException, RemoteException, IOException, CancelException {
        IUser knownUser;
        this.offlineUser = null;
        boolean result = super.logon(user);
        if (result) {
            this.userManager.saveUser(user);
        } else if (this.isOffline() && (knownUser = this.userManager.getUser(user.getLogin())) != null && knownUser.getPassword().equals(user.getPassword())) {
            this.offlineUser = knownUser;
            result = true;
        }
        return result;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.cancel = this.cancelable;
    }

    @Override
    public IUser getCurrentUser() {
        IUser result = super.getCurrentUser();
        return result == null ? this.offlineUser : result;
    }

    @Override
    public IMailMessage getMessage(Folder folder, String id) throws IOException, CancelException {
        this.verifyUser();
        IMailMessage result = null;
        if (folder == Folder.INBOX) {
            result = (IMailMessage)this.searchStorage(id);
        }
        if (result == null) {
            result = super.getMessage(folder, id);
            if (folder == Folder.INBOX && result != null) {
                IStorage<IDPSMessage> storage = this.getStorage(result.getEmpRef());
                storage.store((IDPSMessage)result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... empRefs) throws IOException, CancelException {
        this.verifyUser();
        List<IMailMessage> result = super.getMessages(folder, empRefs);
        if (folder == Folder.INBOX) {
            ArrayList<IMailMessage> downloaded = new ArrayList<IMailMessage>(result);
            result.addAll(super.readStorage(empRefs.length > 0 ? empRefs : this.getCurrentUser().getEmpRef()));
            this.cancelable = this.storageFactory.isInTransaction();
            try {
                for (IMailMessage msg : downloaded) {
                    if (this.cancel) {
                        throw new CancelException();
                    }
                    IDPSMessage dpsMessage = (IDPSMessage)msg;
                    IStorage<IDPSMessage> storage = this.getStorage(msg.getEmpRef());
                    storage.store(dpsMessage);
                }
            }
            finally {
                this.cancelable = false;
                this.cancel = false;
            }
        }
        return result;
    }

    @Override
    public void clearDownloads(String ... empRefs) throws IOException, CancelException {
        this.verifyUser();
        super.clearDownloads(empRefs);
    }

    @Override
    public void deleteMessages(Folder folder, String ... ids) throws IOException, CancelException {
        this.verifyUser();
        super.deleteMessages(folder, ids);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.offlineUser = null;
    }

    @Override
    public Folder getMessageFolder(String id) throws IOException, CancelException {
        this.verifyUser();
        Folder result = this.searchStorage(id) != null ? Folder.INBOX : super.getMessageFolder(id);
        return result;
    }

    private void verifyUser() throws IOException {
        if (super.getCurrentUser() == null) {
            if (this.offlineUser != null) {
                boolean result;
                try {
                    result = super.logon(this.offlineUser);
                }
                catch (CancelException e) {
                    return;
                }
                if (result) {
                    this.offlineUser = null;
                } else if (!this.isOffline()) {
                    this.offlineUser = null;
                    throw new DPSException(DPSErrorEnum.DPS_ERR_CREDENTIAL_AUTHENTICATION);
                }
            } else {
                throw new IllegalStateException("User not logged in");
            }
        }
    }

    @Override
    protected IStorage<IDPSMessage> getStorage(String empRef) throws IOException, CancelException {
        return this.storageFactory.getStorage(Folder.INBOX.alias(), empRef, IDPSMessage.class);
    }

    @Override
    protected boolean isDeleteApplicable(Folder folder) {
        return folder == Folder.INBOX;
    }
}

