/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.FormType;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.WrappingFacade;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.SubmitClass;
import com.selima.fbi.core.wrapper.PAYEMessageWrapper;
import com.selima.fbi.hmrcMark.HMRCMark;
import com.selima.fbi.hmrcMark.HMRCMarkException;
import com.selima.fbi.plugin.PluginException;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.apache.xml.security.Init;

public class HMRCMarkInjectingFacade
extends WrappingFacade {
    public HMRCMarkInjectingFacade(IMailServiceFacade facade) {
        super(facade);
    }

    @Override
    public IPAYEMessage getPAYEMessage(SubmitClass submitClass, String correlationID) throws IOException, CancelException {
        IPAYEMessage result = super.getPAYEMessage(submitClass, correlationID);
        if (result != null) {
            result = (IPAYEMessage)new HMRCMarkInjectingMessage(result).getProxy();
        }
        return result;
    }

    @Override
    public List<IPAYEMessage> getPAYEMessages(FormType formType, int taxYear, String ... empRef) throws IOException, PluginException, CancelException {
        List<IPAYEMessage> result = super.getPAYEMessages(formType, taxYear, empRef);
        ListIterator<IPAYEMessage> it = result.listIterator();
        while (it.hasNext()) {
            it.set((IPAYEMessage)new HMRCMarkInjectingMessage(it.next()).getProxy());
        }
        return result;
    }

    private static class HMRCMarkInjectingMessage
    extends PAYEMessageWrapper<IPAYEMessage>
    implements HMRCMarkCapableMessage {
        byte[] augmentedBytes;

        HMRCMarkInjectingMessage(IPAYEMessage payeMessage) {
            super(payeMessage, IPAYEMessage.class);
        }

        @Override
        public String applyHMRCMark() throws HMRCMarkException, IOException {
            byte[] bytes = this.getBytes();
            String hmrcMark = HMRCMark.createFrom(bytes);
            this.augmentedBytes = HMRCMark.addInto(bytes, hmrcMark);
            return hmrcMark;
        }

        @Override
        public void clearHMRCMark() {
            this.augmentedBytes = null;
        }

        @Override
        public byte[] getBytes() throws IOException {
            if (this.augmentedBytes != null) {
                return this.augmentedBytes;
            }
            return super.getBytes();
        }

        @Override
        public byte[] getBytesForTransmission() throws IOException {
            if (this.augmentedBytes != null) {
                return this.augmentedBytes;
            }
            return super.getBytesForTransmission();
        }

        static {
            Init.init();
        }
    }

    public static interface HMRCMarkCapableMessage
    extends IPAYEMessage {
        public String applyHMRCMark() throws HMRCMarkException, IOException;

        public void clearHMRCMark();
    }
}

