/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.FormType;
import com.selima.fbi.HMRCMarkInjectingFacade;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.WrappingFacade;
import com.selima.fbi.core.IMovMessage;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.IRTIMessage;
import com.selima.fbi.core.SubmitClass;
import com.selima.fbi.core.response.HMRCMarkReceipt;
import com.selima.fbi.core.response.IResponse;
import com.selima.fbi.core.response.ISuccessResponse;
import com.selima.fbi.core.wrapper.PAYEMessageWrapper;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.submission.SubmitException;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;

public class HMRCMarkCheckingFacade
extends WrappingFacade {
    public HMRCMarkCheckingFacade(IMailServiceFacade facade) {
        super(facade);
    }

    @Override
    public IPAYEMessage getPAYEMessage(SubmitClass submitClass, String correlationID) throws IOException, CancelException {
        IPAYEMessage result = super.getPAYEMessage(submitClass, correlationID);
        if (result instanceof HMRCMarkInjectingFacade.HMRCMarkCapableMessage) {
            result = (IPAYEMessage)new HMRCMarkCheckingMessage((HMRCMarkInjectingFacade.HMRCMarkCapableMessage)result).getProxy();
        }
        return result;
    }

    @Override
    public List<IPAYEMessage> getPAYEMessages(FormType formType, int taxYear, String ... empRef) throws IOException, PluginException, CancelException {
        List<IPAYEMessage> result = super.getPAYEMessages(formType, taxYear, empRef);
        ListIterator<IPAYEMessage> it = result.listIterator();
        while (it.hasNext()) {
            IPAYEMessage next = it.next();
            if (!(next instanceof HMRCMarkInjectingFacade.HMRCMarkCapableMessage) || !HMRCMarkCheckingFacade.isHMRCMarkEnabled(next)) continue;
            it.set((IPAYEMessage)new HMRCMarkCheckingMessage((HMRCMarkInjectingFacade.HMRCMarkCapableMessage)next).getProxy());
        }
        return result;
    }

    static boolean isHMRCMarkEnabled(IPAYEMessage message) {
        return message instanceof IRTIMessage || message instanceof IMovMessage && message.getTaxYearEnd() >= 2008;
    }

    public static class HMRCMarkCheckException
    extends SubmitException {
        String htmlText;

        HMRCMarkCheckException(String text) {
            super(null, text);
        }

        public HMRCMarkCheckException(String text, String details) {
            super(null, text);
            this.htmlText = "<html>" + details + "</html>";
        }

        public String getDetails() {
            return this.htmlText;
        }
    }

    static class HMRCMarkCheckingMessage
    extends PAYEMessageWrapper<HMRCMarkInjectingFacade.HMRCMarkCapableMessage> {
        HMRCMarkCheckingMessage(HMRCMarkInjectingFacade.HMRCMarkCapableMessage payeMessage) {
            super(payeMessage, HMRCMarkInjectingFacade.HMRCMarkCapableMessage.class);
        }

        @Override
        public IResponse validate() throws IOException, CancelException, SubmitException {
            ((HMRCMarkInjectingFacade.HMRCMarkCapableMessage)this.wrapped).applyHMRCMark();
            try {
                IResponse iResponse = super.validate();
                return iResponse;
            }
            finally {
                ((HMRCMarkInjectingFacade.HMRCMarkCapableMessage)this.wrapped).clearHMRCMark();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IResponse submit() throws IOException, CancelException, SubmitException {
            try {
                ISuccessResponse successResponse;
                HMRCMarkReceipt receipt;
                String irMark = ((HMRCMarkInjectingFacade.HMRCMarkCapableMessage)this.wrapped).applyHMRCMark();
                IResponse result = super.submit();
                if (result instanceof ISuccessResponse && ((receipt = (successResponse = (ISuccessResponse)result).getHMRCMarkReceipt()) == null || !irMark.equals(receipt.getIrMark()))) {
                    if (receipt == null) {
                        throw new HMRCMarkCheckException("No HMRCMark receipt found inside Governmental Gateway response.This is hopefully just a software error but might also be result of a security breach.<p>Please contact technical assistance.</p>");
                    }
                    String expected = HMRCMarkReceipt.getFormattedIrMark(irMark);
                    String found = receipt.getFormattedIrMark();
                    throw new HMRCMarkCheckException("Received invalid HMRCMark receipt. This is hopefully just a software error but might also be result of a security breach.<p>Please contact technical assistance.</p>", "<ul><li>Expected <span style='color:olive'>" + expected + "</span>.<li>Provided <span style='color:olive'>" + found + "</span>.</ul>");
                }
                IResponse iResponse = result;
                return iResponse;
            }
            finally {
                ((HMRCMarkInjectingFacade.HMRCMarkCapableMessage)this.wrapped).clearHMRCMark();
            }
        }
    }
}

