/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.DPSServiceListener;
import com.selima.fbi.DPSType;
import com.selima.fbi.Folder;
import com.selima.fbi.FormType;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.NetworkListener;
import com.selima.fbi.PAYEServiceListener;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.SubmitClass;
import com.selima.fbi.gotvalue.GotValueManager;
import com.selima.fbi.gotvalue.IGotValueManager;
import com.selima.fbi.loader.DPSMessageLoader;
import com.selima.fbi.plugin.IPayrollPluginListener;
import com.selima.fbi.plugin.PluginType;
import com.selima.fbi.service.DPSErrorEnum;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.service.IDpsAuthenticationClient;
import com.selima.fbi.service.IDpsClient;
import com.selima.fbi.service.IMailService;
import com.selima.fbi.service.MailServiceException;
import com.selima.fbi.soap.ICredentialsOwner;
import com.selima.fbi.soap.ISAMLTokenOwner;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.submission.core.body.IStatusReport;
import com.selima.fbi.user.IProxySettings;
import com.selima.fbi.user.IUser;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.fbi.util.DOMUtil;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Element;

public class DPSFacade
implements IMailServiceFacade,
ICredentialsOwner,
ISAMLTokenOwner {
    static final String VENDOR_ID = MailServiceConfig.getInitParameter("dps.vendorId", "0190");
    EventBroadcast<DPSServiceListener> dpsListeners;
    IDpsAuthenticationClient authenticationClient;
    DPSMessageLoader dpsMessageLoader;
    PluginType defaultPluginType;
    IGotValueManager gotValues;
    volatile boolean cancel;
    IDpsClient dpsClient;
    String alias;
    String token;
    IUser user;

    public DPSFacade(IMailService service, IStorageFactory storageFactory) throws MailServiceException {
        this(service, new GotValueManager(storageFactory));
    }

    DPSFacade(IMailService service, IGotValueManager gotManager) throws MailServiceException {
        this.alias = service.getAlias();
        this.gotValues = gotManager;
        this.dpsMessageLoader = new DPSMessageLoader();
        this.defaultPluginType = service.getDefaultPluginType();
        this.dpsListeners = EventBroadcastFactory.createEventBroadcast(DPSServiceListener.class);
        this.authenticationClient = service.createDpsAuthenticationClient(this);
        this.dpsClient = this.newTokenUpdatingDpsClient(service.createDpsClient(this));
    }

    @Override
    public boolean isOffline() {
        return false;
    }

    @Override
    public boolean testConnection(IProxySettings proxy) throws RemoteException, CancelException {
        if (this.user == null) {
            throw new IllegalStateException();
        }
        try {
            this.authenticationClient.DPSrequestToken(1, VENDOR_ID);
            return true;
        }
        catch (DPSException e) {
            return true;
        }
        catch (ConnectException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logon(IUser user) throws DPSException, RemoteException, CancelException {
        this.user = user;
        boolean success = false;
        try {
            success = this.obtainToken();
            if (!success) {
                LogAPI.logInfo((String)("DPS Service: Password failure for " + user.getLogin()));
            }
            boolean bl = success;
            return bl;
        }
        catch (ConnectException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (!success) {
                this.user = null;
            }
        }
    }

    @Override
    public IUser getCurrentUser() {
        return this.user;
    }

    @Override
    public boolean verifyAccess(String empref) throws DPSException, RemoteException, CancelException {
        if (this.user == null) {
            throw new IllegalStateException();
        }
        try {
            this.dpsClient.DPSquery(1, VENDOR_ID, "PAYE", "EmpRef", empref, "P9", 0L);
            return true;
        }
        catch (ConnectException e) {
            return false;
        }
        catch (DPSException e) {
            if (e.isType(DPSErrorEnum.DPS_ERR_UNAUTHORISED_REFERENCE)) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public Folder getMessageFolder(String id) {
        return null;
    }

    @Override
    public IDPSMessage getMessage(Folder folder, String id) throws IOException {
        return null;
    }

    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... empRef) throws DPSException, RemoteException, IOException, CancelException {
        if (Folder.INBOX != folder || this.user == null) {
            return new ArrayList<IMailMessage>(0);
        }
        this.cancel = false;
        this.gotValues.beginTransaction();
        try {
            DownloadProcess downloadProcess = empRef.length == 0 ? this.downloadForAllEmployers() : this.downloadForSelectedEmployers(empRef);
            ArrayList<IMailMessage> result = new ArrayList<IMailMessage>(downloadProcess.execute());
            this.gotValues.commitTransaction();
            return result;
        }
        catch (DownloadException e) {
            this.gotValues.rollbackTransaction();
            if (!(e.getCause() instanceof ConnectException)) {
                e.throwCause();
            }
        }
        catch (RuntimeException e) {
            this.gotValues.rollbackTransaction();
            throw e;
        }
        catch (Error e) {
            this.gotValues.rollbackTransaction();
            throw e;
        }
        return new ArrayList<IMailMessage>(0);
    }

    @Override
    public void clearDownloads(String ... empRef) throws IOException, CancelException {
        this.gotValues.beginTransaction();
        try {
            for (String employer : empRef) {
                for (DPSType type : DPSType.all()) {
                    this.gotValues.setGotValue(employer, type.name(), 0L);
                }
            }
            this.gotValues.commitTransaction();
        }
        catch (IOException e) {
            this.gotValues.rollbackTransaction();
            throw e;
        }
    }

    @Override
    public void deleteMessages(Folder folder, ArrayList<IDPSMessage> messages) {
    }

    @Override
    public void deleteMessages(Folder folder, String ... ids) {
    }

    @Override
    public void destroy() {
        this.user = null;
        this.token = null;
    }

    private List<IDPSMessage> parseMessages(List<Element> elements) throws CancelException {
        return this.parseMessages(elements, new ArrayList<IDPSMessage>(elements.size()));
    }

    private List<IDPSMessage> parseMessages(List<Element> elements, List<IDPSMessage> result) throws CancelException {
        for (Element element : elements) {
            try {
                if (this.cancel) {
                    throw new CancelException();
                }
                result.add((IDPSMessage)this.dpsMessageLoader.load(element));
            }
            catch (IOException e) {
                String message = DOMUtil.toString(element);
                if (message == null) continue;
                if (message.startsWith("<?xml")) {
                    message = message.substring(message.indexOf("?>") + "?>".length());
                }
                LogAPI.logWarning((String)("Malformed message:[" + message + "]"));
                ((DPSServiceListener)this.dpsListeners.getListener()).malformedMessage(message, element);
            }
        }
        return result;
    }

    private DownloadProcess downloadForSelectedEmployers(String ... empRef) throws DownloadException {
        DownloadProcess downloadProcess = new DownloadProcess(empRef.length);
        List<String> validRef = Arrays.asList(this.user.getEmpRef());
        for (String employer : empRef) {
            assert (validRef.contains(employer)) : "'" + this.user.getLogin() + "' is not permitted to access '" + employer + "'";
            downloadProcess.add(new EmployerDownloadSequence(employer));
        }
        return downloadProcess;
    }

    private DownloadProcess downloadForAllEmployers() throws DownloadException {
        DownloadProcess downloadProcess = new DownloadProcess(this.user.getEmpRef().length + 1);
        for (String employer : this.user.getEmpRef()) {
            downloadProcess.add(new EmployerDownloadSequence(employer));
        }
        downloadProcess.add(new UnknownDownloadSequence());
        return downloadProcess;
    }

    @Override
    public void removeDPSServiceListener(DPSServiceListener listener) {
        this.dpsListeners.removeListener((Object)listener);
    }

    @Override
    public void addNetworkListener(NetworkListener listener) {
    }

    @Override
    public void removeNetworkListener(NetworkListener listener) {
    }

    @Override
    public void addDPSServiceListener(DPSServiceListener listener) {
        this.dpsListeners.addListener((Object)listener);
    }

    @Override
    public void addPAYEServiceListener(PAYEServiceListener listener) {
    }

    @Override
    public void removePAYEServiceListener(PAYEServiceListener listener) {
    }

    @Override
    public void addPayrollPluginListener(IPayrollPluginListener listener) {
    }

    @Override
    public void removePayrollPluginListener(IPayrollPluginListener listener) {
    }

    @Override
    public String getUsername() {
        return this.user.getLogin();
    }

    @Override
    public String getPassword() {
        return this.user.getPassword();
    }

    @Override
    public String getSAMLToken() {
        return this.token;
    }

    private boolean obtainToken() throws DPSException, RemoteException, ConnectException, CancelException {
        try {
            this.token = null;
            this.token = this.authenticationClient.DPSrequestToken(1, VENDOR_ID);
            return true;
        }
        catch (DPSException e) {
            if (e.isType(DPSErrorEnum.DPS_ERR_INVALID_CREDENTIALS) || e.isType(DPSErrorEnum.DPS_ERR_CREDENTIAL_AUTHENTICATION)) {
                return false;
            }
            throw e;
        }
    }

    IDpsClient newTokenUpdatingDpsClient(IDpsClient client) {
        return (IDpsClient)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IDpsClient.class}, (InvocationHandler)new TokenUpdatingDpsHandler(client));
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    @Override
    public IPAYEMessage getPAYEMessage(SubmitClass submitClass, String correlationID) {
        return null;
    }

    @Override
    public List<IPAYEMessage> getPAYEMessages(FormType formType, int taxYear, String ... empRef) {
        return Collections.emptyList();
    }

    @Override
    public IStatusReport getPAYEStatusReport(SubmitClass submitClass, Date startDate, Date endDate) {
        return null;
    }

    @Override
    public PluginType getDefaultPluginType() {
        return this.defaultPluginType;
    }

    @Override
    public boolean verifyAccess(IProxySettings settings, String empref) throws DPSException, RemoteException, CancelException {
        return this.verifyAccess(empref);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void testPayroll(PayrollServerSpec payrollServer) {
    }

    @Override
    public boolean isSafeToCancel() {
        return true;
    }

    class UnknownDownloadSequence
    implements DownloadSequence {
        int[] counts = this.query();

        UnknownDownloadSequence() throws DownloadException {
            for (String knownEmployer : DPSFacade.this.user.getEmpRef()) {
                this.subtract(this.counts, knownEmployer);
            }
        }

        @Override
        public int size() {
            int result = 0;
            for (int i = 0; i < this.counts.length; ++i) {
                result += this.counts[i];
            }
            return result;
        }

        @Override
        public DUIterator getIterator() {
            return new DUIterator(){
                DUIterator iterator;

                @Override
                public boolean hasNext() throws DownloadException {
                    if (this.iterator == null || !this.iterator.hasNext()) {
                        this.iterator = null;
                        for (int i = 0; i < UnknownDownloadSequence.this.counts.length; ++i) {
                            String employer;
                            if (UnknownDownloadSequence.this.counts[i] == 0 || (employer = this.findEmployer(DPSType.values()[i])) == null) continue;
                            UnknownDownloadSequence.this.subtract(UnknownDownloadSequence.this.counts, employer);
                            EmployerDownloadSequence sequence = new EmployerDownloadSequence(employer);
                            if (sequence.size() <= 0) continue;
                            this.iterator = sequence.getIterator();
                            return true;
                        }
                        return false;
                    }
                    return true;
                }

                @Override
                public DownloadUnit next() throws DownloadException {
                    if (this.hasNext()) {
                        return this.iterator.next();
                    }
                    return null;
                }

                private String findEmployer(DPSType type) throws DownloadException {
                    try {
                        Interval interval;
                        OpenEndedInterval rightside = new OpenEndedInterval(type, UnknownDownloadSequence.this.maximumGotValue(type));
                        if (rightside.containsUnknown()) {
                            interval = rightside;
                        } else {
                            ClosedInterval inside = new ClosedInterval(0L, rightside);
                            while (!inside.isSmallEnough()) {
                                long pivot = (inside.getUpperBound() + inside.getLowerBound()) / 2L;
                                ClosedInterval upperside = new ClosedInterval(pivot, inside);
                                if (upperside.containsUnknown()) {
                                    inside = upperside;
                                    continue;
                                }
                                inside = new ClosedInterval(inside, upperside);
                            }
                            interval = inside;
                        }
                        long searchPoint = interval.getLowerBound();
                        while (true) {
                            ArrayList<Element> elements = new ArrayList<Element>();
                            long nextSearchPoint = DPSFacade.this.dpsClient.DPSretrieve(1, VENDOR_ID, "PAYE", "EmpRef", "", type.name(), searchPoint, type.chunkSize(), elements);
                            HashSet<String> knownEmployers = new HashSet<String>(Arrays.asList(DPSFacade.this.user.getEmpRef()));
                            for (IDPSMessage message : DPSFacade.this.parseMessages(elements)) {
                                String employer = message.getEmpRef();
                                if (knownEmployers.contains(employer)) continue;
                                DPSFacade.this.user.addEmpRef(employer);
                                ((DPSServiceListener)DPSFacade.this.dpsListeners.getListener()).authorizationGained(DPSFacade.this.user, employer);
                                return employer;
                            }
                            if (interval instanceof ClosedInterval ? nextSearchPoint >= ((ClosedInterval)interval).getUpperBound() : nextSearchPoint == searchPoint) break;
                            searchPoint = nextSearchPoint;
                        }
                        return null;
                    }
                    catch (IOException e) {
                        throw new DownloadException(e);
                    }
                    catch (CancelException e) {
                        throw new DownloadException(e);
                    }
                }
            };
        }

        private int[] query() throws DownloadException {
            try {
                int[] counts = new int[DPSType.all().size()];
                for (DPSType type : DPSType.all()) {
                    counts[type.ordinal()] = DPSFacade.this.dpsClient.DPSquery(1, VENDOR_ID, "PAYE", "EmpRef", "", type.name(), 0L);
                }
                return counts;
            }
            catch (ConnectException e) {
                throw new DownloadException(e);
            }
            catch (RemoteException e) {
                throw new DownloadException(e);
            }
            catch (CancelException e) {
                throw new DownloadException(e);
            }
        }

        private void subtract(int[] counts, String empRef) throws DownloadException {
            try {
                for (DPSType type : DPSType.all()) {
                    int index;
                    int n = index = type.ordinal();
                    counts[n] = counts[n] - DPSFacade.this.dpsClient.DPSquery(1, VENDOR_ID, "PAYE", "EmpRef", empRef, type.name(), 0L);
                    if (counts[index] >= 0) continue;
                    counts[index] = 0;
                }
            }
            catch (ConnectException e) {
                throw new DownloadException(e);
            }
            catch (RemoteException e) {
                throw new DownloadException(e);
            }
            catch (CancelException e) {
                throw new DownloadException(e);
            }
        }

        private long maximumGotValue(DPSType type) throws IOException, CancelException {
            long max = 0L;
            for (String employer : DPSFacade.this.user.getEmpRef()) {
                long value = DPSFacade.this.gotValues.getGotValue(employer, type.name());
                if (value <= max) continue;
                max = value;
            }
            return max;
        }

        class OpenEndedInterval
        extends Interval {
            int numOfAll;
            int numOfUnknown;
            DPSType type;

            OpenEndedInterval(DPSType type, long lowerBound) throws CancelException, DPSException, RemoteException, ConnectException {
                super(type, lowerBound);
                this.type = type;
                this.numOfAll = this.numOfUnknown = DPSFacade.this.dpsClient.DPSquery(1, VENDOR_ID, "PAYE", "EmpRef", "", type.name(), lowerBound);
                for (String knownEmployer : DPSFacade.this.user.getEmpRef()) {
                    this.numOfUnknown -= DPSFacade.this.dpsClient.DPSquery(1, VENDOR_ID, "PAYE", "EmpRef", knownEmployer, type.name(), lowerBound);
                }
            }

            boolean containsUnknown() {
                return this.numOfUnknown > 0;
            }

            public String toString() {
                return "[" + this.lowerBound + ",infinite)";
            }
        }

        class ClosedInterval
        extends Interval {
            OpenEndedInterval lowerInterval;
            OpenEndedInterval upperInterval;

            ClosedInterval(long lowerBound, OpenEndedInterval upperBound) throws CancelException, DPSException, RemoteException, ConnectException {
                super(upperBound.type, lowerBound);
                this.lowerInterval = new OpenEndedInterval(this.type, lowerBound);
                this.upperInterval = upperBound;
            }

            ClosedInterval(long lowerBound, ClosedInterval parentInterval) throws CancelException, DPSException, RemoteException, ConnectException {
                super(parentInterval.type, lowerBound);
                this.lowerInterval = new OpenEndedInterval(this.type, lowerBound);
                this.upperInterval = parentInterval.upperInterval;
            }

            ClosedInterval(ClosedInterval parentInterval, ClosedInterval upperBound) {
                super(parentInterval.type, parentInterval.lowerBound);
                this.lowerInterval = parentInterval.lowerInterval;
                this.upperInterval = upperBound.lowerInterval;
            }

            long getUpperBound() {
                return this.upperInterval.lowerBound;
            }

            boolean containsUnknown() {
                return this.lowerInterval.numOfUnknown - this.upperInterval.numOfUnknown > 0;
            }

            boolean isSmallEnough() {
                return this.lowerInterval.numOfAll - this.upperInterval.numOfAll <= this.type.chunkSize();
            }

            public String toString() {
                return "[" + this.lowerInterval.lowerBound + "," + this.upperInterval.lowerBound + ")";
            }
        }

        abstract class Interval {
            long lowerBound;
            DPSType type;

            Interval(DPSType type, long lowerBound) {
                this.lowerBound = lowerBound;
                this.type = type;
            }

            long getLowerBound() {
                return this.lowerBound;
            }
        }
    }

    class BasicDownloadUnit
    implements DownloadUnit {
        int number;
        DPSType type;
        String employer;

        public BasicDownloadUnit(String employer, DPSType type, int number) {
            this.employer = employer;
            this.number = number;
            this.type = type;
        }

        @Override
        public String name() {
            return this.number + " " + (Object)((Object)this.type) + " for " + this.employer;
        }

        @Override
        public int size() {
            return this.number;
        }

        @Override
        public void download(List<Element> elements) throws DownloadException {
            try {
                long got = DPSFacade.this.gotValues.getGotValue(this.employer, this.type.name());
                got = DPSFacade.this.dpsClient.DPSretrieve(1, VENDOR_ID, "PAYE", "EmpRef", this.employer, this.type.name(), got, this.number, elements);
                DPSFacade.this.gotValues.setGotValue(this.employer, this.type.name(), got);
            }
            catch (DPSException e) {
                throw new DownloadException(e);
            }
            catch (RemoteException e) {
                throw new DownloadException(e);
            }
            catch (IOException e) {
                throw new DownloadException(e);
            }
            catch (CancelException e) {
                throw new DownloadException(e);
            }
        }
    }

    class EmployerDownloadSequence
    implements DownloadSequence {
        String employer;
        int[] counts;
        int index;

        EmployerDownloadSequence(String employer) throws DownloadException {
            this.employer = employer;
            try {
                this.counts = new int[DPSType.all().size()];
                for (DPSType type : DPSType.all()) {
                    long got = DPSFacade.this.gotValues.getGotValue(employer, type.name());
                    this.counts[type.ordinal()] = DPSFacade.this.dpsClient.DPSquery(1, VENDOR_ID, "PAYE", "EmpRef", employer, type.name(), got);
                }
            }
            catch (DPSException e) {
                if (e.isType(DPSErrorEnum.DPS_ERR_UNAUTHORISED_REFERENCE)) {
                    DPSFacade.this.user.removeEmpRef(employer);
                    ((DPSServiceListener)DPSFacade.this.dpsListeners.getListener()).authorizationLost(DPSFacade.this.user, employer);
                }
                throw new DownloadException(e);
            }
            catch (RemoteException e) {
                throw new DownloadException(e);
            }
            catch (IOException e) {
                throw new DownloadException(e);
            }
            catch (CancelException e) {
                throw new DownloadException(e);
            }
        }

        @Override
        public int size() {
            int result = 0;
            for (int i = 0; i < this.counts.length; ++i) {
                result += this.counts[i];
            }
            return result;
        }

        int[] getCounts() {
            return this.counts;
        }

        @Override
        public DUIterator getIterator() {
            return new DUIterator(){

                @Override
                public boolean hasNext() throws DownloadException {
                    while (EmployerDownloadSequence.this.index < EmployerDownloadSequence.this.counts.length) {
                        if (EmployerDownloadSequence.this.counts[EmployerDownloadSequence.this.index] > 0) {
                            return true;
                        }
                        ++EmployerDownloadSequence.this.index;
                    }
                    return false;
                }

                @Override
                public DownloadUnit next() throws DownloadException {
                    if (this.hasNext()) {
                        DPSType type = DPSType.all().get(EmployerDownloadSequence.this.index);
                        int number = Math.min(EmployerDownloadSequence.this.counts[EmployerDownloadSequence.this.index], type.chunkSize());
                        int n = EmployerDownloadSequence.this.index;
                        EmployerDownloadSequence.this.counts[n] = EmployerDownloadSequence.this.counts[n] - number;
                        return new BasicDownloadUnit(EmployerDownloadSequence.this.employer, type, number);
                    }
                    return null;
                }
            };
        }
    }

    static interface DownloadUnit {
        public String name();

        public int size();

        public void download(List<Element> var1) throws DownloadException;
    }

    static interface DownloadSequence {
        public int size();

        public DUIterator getIterator();
    }

    static interface DUIterator {
        public boolean hasNext() throws DownloadException;

        public DownloadUnit next() throws DownloadException;
    }

    class DownloadProcess {
        int numOfMessages;
        List<DownloadSequence> downloads;

        DownloadProcess(int size) {
            this.downloads = new ArrayList<DownloadSequence>(size);
        }

        void add(DownloadSequence sequence) throws DownloadException {
            if (sequence.size() > 0) {
                this.numOfMessages += sequence.size();
                this.downloads.add(sequence);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<IDPSMessage> execute() throws DownloadException, CancelException {
            ArrayList<IDPSMessage> result = new ArrayList<IDPSMessage>(this.numOfMessages);
            if (this.numOfMessages == 0) {
                ((DPSServiceListener)DPSFacade.this.dpsListeners.getListener()).noNewMessagesOnServer();
                return result;
            }
            ((DPSServiceListener)DPSFacade.this.dpsListeners.getListener()).downloadStarted(this.numOfMessages);
            try {
                int count = 0;
                for (int i = 0; i < this.downloads.size(); ++i) {
                    DUIterator it = this.downloads.get(i).getIterator();
                    while (it.hasNext()) {
                        DownloadUnit unit = it.next();
                        ArrayList<Element> elements = new ArrayList<Element>(unit.size());
                        unit.download(elements);
                        DPSFacade.this.parseMessages(elements, result);
                        ((DPSServiceListener)DPSFacade.this.dpsListeners.getListener()).downloaded(unit.name(), count += unit.size());
                    }
                }
                ArrayList<IDPSMessage> arrayList = result;
                return arrayList;
            }
            finally {
                ((DPSServiceListener)DPSFacade.this.dpsListeners.getListener()).downloadFinished();
            }
        }
    }

    class DownloadException
    extends Exception {
        DownloadException(IOException e) {
            super(e);
        }

        DownloadException(DPSException e) {
            super(e);
        }

        DownloadException(RemoteException e) {
            super(e);
        }

        DownloadException(ConnectException e) {
            super(e);
        }

        DownloadException(CancelException e) {
            super(e);
        }

        void throwCause() throws CancelException, IOException, DPSException, RemoteException {
            if (this.getCause() instanceof IOException) {
                throw (IOException)this.getCause();
            }
            if (this.getCause() instanceof DPSException) {
                throw (DPSException)this.getCause();
            }
            if (this.getCause() instanceof RemoteException) {
                throw (RemoteException)this.getCause();
            }
            if (this.getCause() instanceof CancelException) {
                throw (CancelException)this.getCause();
            }
        }
    }

    class TokenUpdatingDpsHandler
    implements InvocationHandler {
        IDpsClient wrappedClient;

        TokenUpdatingDpsHandler(IDpsClient dpsClient) {
            this.wrappedClient = dpsClient;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.wrappedClient, args);
            }
            catch (InvocationTargetException e) {
                if (this.isExpiredToken(e.getCause()) && DPSFacade.this.obtainToken()) {
                    try {
                        return method.invoke((Object)this.wrappedClient, args);
                    }
                    catch (InvocationTargetException ex) {
                        e = ex;
                    }
                }
                throw e.getCause();
            }
        }

        private boolean isExpiredToken(Throwable e) {
            if (e instanceof DPSException) {
                DPSException dpse = (DPSException)e;
                return dpse.isType(DPSErrorEnum.DPS_ERR_TOKEN_AUTHENTICATION);
            }
            return false;
        }
    }
}

