/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.CancelabilityState;
import com.selima.fbi.Folder;
import com.selima.fbi.FormType;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.WrappingFacade;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.SubmitClass;
import com.selima.fbi.core.response.IResponse;
import com.selima.fbi.core.wrapper.DPSMessageWrapper;
import com.selima.fbi.core.wrapper.PAYEMessageWrapper;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.submission.SubmitException;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;

public class CancelingStorageFactoryFacade
extends WrappingFacade {
    CancelabilityState cancelability;
    IStorageFactory storageFactory;

    public CancelingStorageFactoryFacade(IMailServiceFacade facade, IStorageFactory storageFactory, CancelabilityState cancelability) {
        super(facade);
        this.cancelability = cancelability;
        this.storageFactory = storageFactory;
    }

    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... empref) throws IOException, CancelException {
        List<IMailMessage> result = super.getMessages(folder, empref);
        ListIterator<IMailMessage> it = result.listIterator();
        while (it.hasNext()) {
            IMailMessage message = it.next();
            if (message instanceof IDPSMessage) {
                it.set((IMailMessage)new SafetyDPSMessage((IDPSMessage)message).getProxy());
                continue;
            }
            if (!(message instanceof IPAYEMessage)) continue;
            it.set((IMailMessage)new SafetyPAYEMessage((IPAYEMessage)message).getProxy());
        }
        return result;
    }

    @Override
    public IMailMessage getMessage(Folder folder, String id) throws IOException, CancelException {
        IMailMessage result = super.getMessage(folder, id);
        if (result instanceof IDPSMessage) {
            return new SafetyDPSMessage((IDPSMessage)result).getProxy();
        }
        if (result instanceof IPAYEMessage) {
            return new SafetyPAYEMessage((IPAYEMessage)result).getProxy();
        }
        return result;
    }

    @Override
    public IPAYEMessage getPAYEMessage(SubmitClass submitClass, String correlationID) throws IOException, CancelException {
        IPAYEMessage result = super.getPAYEMessage(submitClass, correlationID);
        if (result != null) {
            result = (IPAYEMessage)new SafetyPAYEMessage(result).getProxy();
        }
        return result;
    }

    @Override
    public List<IPAYEMessage> getPAYEMessages(FormType formType, int taxYear, String ... empRef) throws IOException, PluginException, CancelException {
        List<IPAYEMessage> result = super.getPAYEMessages(formType, taxYear, empRef);
        ListIterator<IPAYEMessage> it = result.listIterator();
        while (it.hasNext()) {
            it.set((IPAYEMessage)new SafetyPAYEMessage(it.next()).getProxy());
        }
        return result;
    }

    @Override
    public boolean isSafeToCancel() {
        return this.cancelability.isSafe();
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.storageFactory.isInTransaction()) {
            this.storageFactory.cancel();
        }
    }

    class SafetyPAYEMessage
    extends PAYEMessageWrapper<IPAYEMessage> {
        SafetyPAYEMessage(IPAYEMessage payeMessage) {
            super(payeMessage, IPAYEMessage.class);
        }

        @Override
        public IResponse submit() throws IOException, CancelException, SubmitException {
            try {
                IResponse iResponse = super.submit();
                return iResponse;
            }
            finally {
                CancelingStorageFactoryFacade.this.cancelability.setSafe(true);
            }
        }

        @Override
        public IResponse complete() throws IOException, CancelException, SubmitException {
            try {
                IResponse iResponse = super.complete();
                return iResponse;
            }
            finally {
                CancelingStorageFactoryFacade.this.cancelability.setSafe(true);
            }
        }
    }

    class SafetyDPSMessage
    extends DPSMessageWrapper {
        SafetyDPSMessage(IDPSMessage message) {
            super(message);
        }

        @Override
        public void transfer(boolean firstInBatch) throws IOException, PluginException, CancelException {
            try {
                super.transfer(firstInBatch);
            }
            finally {
                CancelingStorageFactoryFacade.this.cancelability.setSafe(true);
            }
        }
    }
}

