/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.NetworkTracker;
import com.selima.fbi.OfflineDPSFacade;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.gotvalue.IGotValueManager;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.service.IDpsAuthenticationClient;
import com.selima.fbi.service.IDpsClient;
import com.selima.fbi.service.IMailService;
import com.selima.fbi.service.MailServiceException;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.user.IProxySettings;
import com.selima.fbi.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;

public class CancelableDPSFacade
extends OfflineDPSFacade {
    volatile boolean cancel;
    volatile boolean cancelable;

    public CancelableDPSFacade(IMailService service, IStorageFactory storageFactory, NetworkTracker networkTracker) throws MailServiceException {
        super(service, storageFactory, networkTracker);
        this.init();
    }

    CancelableDPSFacade(IMailService service, IGotValueManager gotValues, NetworkTracker networkTracker) throws MailServiceException {
        super(service, gotValues, networkTracker);
        this.init();
    }

    protected CancelableDPSFacade(IMailService mailService, IGotValueManager gotValueManager) throws MailServiceException {
        this(mailService, gotValueManager, new NetworkTracker());
    }

    private void init() {
        this.authenticationClient = this.newCancelingDpsAuthenticationClient(this.authenticationClient);
        this.dpsClient = this.newCancelingDpsClient(this.dpsClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... empRef) throws DPSException, RemoteException, IOException, CancelException {
        this.cancelable = true;
        try {
            List<IMailMessage> list = super.getMessages(folder, empRef);
            return list;
        }
        finally {
            this.cancelable = false;
            this.cancel = false;
        }
    }

    @Override
    public boolean verifyAccess(String empref) throws DPSException, RemoteException, CancelException {
        this.cancelable = true;
        try {
            boolean bl = super.verifyAccess(empref);
            return bl;
        }
        finally {
            this.cancelable = false;
            this.cancel = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyAccess(IProxySettings settings, String empref) throws DPSException, RemoteException, CancelException {
        this.cancelable = true;
        try {
            boolean bl = super.verifyAccess(settings, empref);
            return bl;
        }
        finally {
            this.cancelable = false;
            this.cancel = false;
        }
    }

    @Override
    public boolean testConnection(IProxySettings proxy) throws RemoteException, CancelException {
        this.cancelable = true;
        try {
            boolean bl = super.testConnection(proxy);
            return bl;
        }
        finally {
            this.cancelable = false;
            this.cancel = false;
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.cancel = this.cancelable;
        if (this.cancelable) {
            try {
                this.dpsClient.cancel();
                this.authenticationClient.cancel();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    IDpsAuthenticationClient newCancelingDpsAuthenticationClient(IDpsAuthenticationClient client) {
        return (IDpsAuthenticationClient)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IDpsAuthenticationClient.class}, (InvocationHandler)new CancelingHandler(client));
    }

    IDpsClient newCancelingDpsClient(IDpsClient client) {
        return (IDpsClient)Proxy.newProxyInstance(this.getClass().getClassLoader(), ReflectionUtil.getInterfaces(client), (InvocationHandler)new CancelingHandler(client));
    }

    class CancelingHandler
    implements InvocationHandler {
        Object target;

        CancelingHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (CancelableDPSFacade.this.cancel && CancelableDPSFacade.this.cancelable && Arrays.asList(method.getExceptionTypes()).contains(CancelException.class)) {
                throw new CancelException();
            }
            try {
                return method.invoke(this.target, args);
            }
            catch (InvocationTargetException e) {
                if (CancelableDPSFacade.this.cancel && CancelableDPSFacade.this.cancelable && Arrays.asList(method.getExceptionTypes()).contains(CancelException.class)) {
                    throw new CancelException(e.getCause());
                }
                throw e.getCause();
            }
        }
    }
}

