/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.AbstractFolderFacade;
import com.selima.fbi.ArchiveDetails;
import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.core.IArchivedMessage;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.wrapper.DPSMessageWrapper;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;

public class ArchiveDetailsFacade
extends AbstractFolderFacade<ArchiveDetails> {
    ArchiveDetailsFacade(IMailServiceFacade wrappedFacade, IStorageFactory storageFactory) {
        super(wrappedFacade, storageFactory);
    }

    @Override
    public void deleteMessages(Folder folder, ArrayList<IDPSMessage> messages) throws IOException, CancelException {
        String storeId;
        String[] ids = new String[messages.size()];
        int iloop = 0;
        for (IMailMessage iMailMessage : messages) {
            storeId = iMailMessage.getStoreId();
            ids[iloop++] = storeId;
        }
        if (folder.contentType() == IDPSMessage.class && folder != Folder.ARCHIVE) {
            for (IDPSMessage iDPSMessage : messages) {
                storeId = iDPSMessage.getStoreId();
                IDPSMessage message = (IDPSMessage)this.getMessage(folder, storeId);
                IStorage<ArchiveDetails> storage = this.getStorage(message.getEmpRef());
                storage.store(new ArchiveDetails(message.getStoreSpace(), message.getStoreId(), message.isTransferred(), message.isTransferrable(), folder, message.getTransferDate(), new Date(), iDPSMessage.getPayrollWarningMessage()));
            }
        }
        super.deleteMessages(folder, ids);
    }

    @Override
    public void deleteMessages(Folder folder, String ... ids) throws IOException, CancelException {
        if (folder.contentType() == IDPSMessage.class && folder != Folder.ARCHIVE) {
            for (String id : ids) {
                IDPSMessage message = (IDPSMessage)this.getMessage(folder, id);
                IStorage<ArchiveDetails> storage = this.getStorage(message.getEmpRef());
                storage.store(new ArchiveDetails(message.getStoreSpace(), message.getStoreId(), message.isTransferred(), message.isTransferrable(), folder, message.getTransferDate(), new Date(), message.getPayrollWarningMessage()));
            }
        }
        super.deleteMessages(folder, ids);
    }

    @Override
    public IMailMessage getMessage(Folder folder, String id) throws IOException, CancelException {
        IStorage<ArchiveDetails> storage;
        IMailMessage result = super.getMessage(folder, id);
        if (result != null && folder == Folder.ARCHIVE && (storage = this.getStorage(result.getEmpRef())).contains(result.getStoreId())) {
            ArchiveDetails details = storage.load(result.getStoreId());
            result = new ArchiveMessage((IDPSMessage)result, details).getProxy();
        }
        return result;
    }

    @Override
    public List<IMailMessage> getMessages(Folder folder, String ... empref) throws IOException, CancelException {
        List<IMailMessage> result = super.getMessages(folder, empref);
        if (folder == Folder.ARCHIVE) {
            ListIterator<IMailMessage> it = result.listIterator();
            while (it.hasNext()) {
                IMailMessage message = it.next();
                IStorage<ArchiveDetails> storage = this.getStorage(message.getEmpRef());
                if (!storage.contains(message.getStoreId())) continue;
                ArchiveDetails details = storage.load(message.getStoreId());
                message = new ArchiveMessage((IDPSMessage)message, details).getProxy();
                it.set(message);
            }
        }
        return result;
    }

    @Override
    protected boolean isDeleteApplicable(Folder folder) {
        return folder == Folder.ARCHIVE;
    }

    @Override
    protected IStorage<ArchiveDetails> getStorage(String empRef) throws IOException, CancelException {
        return this.storageFactory.getStorage("archive-details", empRef, ArchiveDetails.class);
    }

    class ArchiveMessage
    extends DPSMessageWrapper
    implements IArchivedMessage {
        boolean transferrable;
        boolean transferred;
        Date deletionDate;
        Date transferDate;
        Folder originalFolder;
        String payrollWarningMessage;

        ArchiveMessage(IDPSMessage message, ArchiveDetails details) {
            super(message);
            this.deletionDate = details.getDeletionDate();
            this.transferDate = details.getTransferDate();
            this.transferrable = details.isTransferable();
            this.transferred = details.isTransferred();
            this.originalFolder = details.getFolder();
            this.payrollWarningMessage = details.getPayrollWarningMessage();
        }

        @Override
        public boolean isTransferrable() {
            return this.transferrable;
        }

        @Override
        public boolean isTransferred() {
            return this.transferred;
        }

        @Override
        public Date getDeletionDate() {
            return this.deletionDate;
        }

        @Override
        public Folder getOriginalFolder() {
            return this.originalFolder;
        }

        @Override
        public Date getTransferDate() {
            return this.transferDate;
        }

        @Override
        public String getPayrollWarningMessage() {
            return this.payrollWarningMessage;
        }
    }
}

