/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi;

import com.selima.fbi.CancelabilityState;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.NetworkTracker;
import com.selima.fbi.PAYEServiceListener;
import com.selima.fbi.SafetySubmissionProcessor;
import com.selima.fbi.WrappingFacade;
import com.selima.fbi.service.IMailService;
import com.selima.fbi.submission.IStaticSubmissionContext;
import com.selima.fbi.submission.ISubmissionContext;
import com.selima.fbi.submission.ISubmissionProcessor;
import com.selima.fbi.submission.XMLSignatureSubmissionProcessor;
import com.selima.fbi.submission.sender.IGovTalkMessageSender;
import com.selima.fbi.user.IUser;
import java.io.File;

public abstract class AbstractSubmissionFacade
extends WrappingFacade {
    ISubmissionProcessor submissionProcessor;
    NetworkTracker networkTracker;

    public AbstractSubmissionFacade(IMailServiceFacade facade, IMailService service, NetworkTracker networkTracker, CancelabilityState cancelability) {
        super(facade);
        this.networkTracker = networkTracker;
        this.submissionProcessor = new SafetySubmissionProcessor(new XMLSignatureSubmissionProcessor(new DynamicSubmissionContext(service.createSubmissionContext())), cancelability);
    }

    @Override
    public void addPAYEServiceListener(PAYEServiceListener listener) {
        this.submissionProcessor.addSubmitListener(listener);
        super.addPAYEServiceListener(listener);
    }

    @Override
    public void removePAYEServiceListener(PAYEServiceListener listener) {
        this.submissionProcessor.removeSubmitListener(listener);
        super.removePAYEServiceListener(listener);
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.submissionProcessor.isActive()) {
            this.submissionProcessor.cancel();
        }
    }

    class DynamicSubmissionContext
    implements ISubmissionContext {
        IStaticSubmissionContext context;

        public DynamicSubmissionContext(IStaticSubmissionContext context) {
            this.context = context;
        }

        @Override
        public IUser getCurrentUser() {
            return AbstractSubmissionFacade.this.getCurrentUser();
        }

        @Override
        public IGovTalkMessageSender getSender() {
            return this.context.getSender();
        }

        @Override
        public File getLogDir() {
            return this.context.getLogDir();
        }

        @Override
        public int getStepLimit() {
            return this.context.getStepLimit();
        }

        @Override
        public boolean isLogEnabled() {
            return this.context.isLogEnabled();
        }

        @Override
        public NetworkTracker getNetworkTracker() {
            return AbstractSubmissionFacade.this.networkTracker;
        }
    }
}

