/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;

public class ResolverDirectHTTP
extends ResourceResolverSpi {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$utils$resolver$implementations$ResolverDirectHTTP == null ? (class$org$apache$xml$security$utils$resolver$implementations$ResolverDirectHTTP = ResolverDirectHTTP.class$("org.apache.xml.security.utils.resolver.implementations.ResolverDirectHTTP")) : class$org$apache$xml$security$utils$resolver$implementations$ResolverDirectHTTP).getName());
    private static final String[] properties = new String[]{"http.proxy.host", "http.proxy.port", "http.proxy.username", "http.proxy.password", "http.basic.username", "http.basic.password"};
    private static final int HttpProxyHost = 0;
    private static final int HttpProxyPort = 1;
    private static final int HttpProxyUser = 2;
    private static final int HttpProxyPass = 3;
    private static final int HttpBasicUser = 4;
    private static final int HttpBasicPass = 5;
    static /* synthetic */ Class class$org$apache$xml$security$utils$resolver$implementations$ResolverDirectHTTP;

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        try {
            String auth;
            boolean switchBackProxy;
            boolean useProxy = false;
            String proxyHost = this.engineGetProperty(properties[0]);
            String proxyPort = this.engineGetProperty(properties[1]);
            if (proxyHost != null && proxyPort != null) {
                useProxy = true;
            }
            String oldProxySet = (String)((Hashtable)System.getProperties()).get("http.proxySet");
            String oldProxyHost = (String)((Hashtable)System.getProperties()).get("http.proxyHost");
            String oldProxyPort = (String)((Hashtable)System.getProperties()).get("http.proxyPort");
            boolean bl = switchBackProxy = oldProxySet != null && oldProxyHost != null && oldProxyPort != null;
            if (useProxy) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Use of HTTP proxy enabled: " + proxyHost + ":" + proxyPort));
                }
                ((Hashtable)System.getProperties()).put("http.proxySet", "true");
                ((Hashtable)System.getProperties()).put("http.proxyHost", proxyHost);
                ((Hashtable)System.getProperties()).put("http.proxyPort", proxyPort);
            }
            URI uriNew = this.getNewURI(uri.getNodeValue(), BaseURI);
            URI uriNewNoFrag = new URI(uriNew);
            uriNewNoFrag.setFragment(null);
            URL url = new URL(uriNewNoFrag.toString());
            URLConnection urlConnection = url.openConnection();
            String proxyUser = this.engineGetProperty(properties[2]);
            String proxyPass = this.engineGetProperty(properties[3]);
            if (proxyUser != null && proxyPass != null) {
                String password = proxyUser + ":" + proxyPass;
                String encodedPassword = Base64.encode(password.getBytes());
                urlConnection.setRequestProperty("Proxy-Authorization", encodedPassword);
            }
            if ((auth = urlConnection.getHeaderField("WWW-Authenticate")) != null && auth.startsWith("Basic")) {
                String user = this.engineGetProperty(properties[4]);
                String pass = this.engineGetProperty(properties[5]);
                if (user != null && pass != null) {
                    urlConnection = url.openConnection();
                    String password = user + ":" + pass;
                    String encodedPassword = Base64.encode(password.getBytes());
                    urlConnection.setRequestProperty("Authorization", "Basic " + encodedPassword);
                }
            }
            String mimeType = urlConnection.getHeaderField("Content-Type");
            InputStream inputStream = urlConnection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int read = 0;
            int summarized = 0;
            while ((read = inputStream.read(buf)) >= 0) {
                baos.write(buf, 0, read);
                summarized += read;
            }
            log.debug((Object)("Fetched " + summarized + " bytes from URI " + uriNew.toString()));
            XMLSignatureInput result = new XMLSignatureInput(baos.toByteArray());
            result.setSourceURI(uriNew.toString());
            result.setMIMEType(mimeType);
            if (switchBackProxy) {
                ((Hashtable)System.getProperties()).put("http.proxySet", oldProxySet);
                ((Hashtable)System.getProperties()).put("http.proxyHost", oldProxyHost);
                ((Hashtable)System.getProperties()).put("http.proxyPort", oldProxyPort);
            }
            return result;
        }
        catch (MalformedURLException ex) {
            throw new ResourceResolverException("generic.EmptyMessage", ex, uri, BaseURI);
        }
        catch (IOException ex) {
            throw new ResourceResolverException("generic.EmptyMessage", ex, uri, BaseURI);
        }
    }

    public boolean engineCanResolve(Attr uri, String BaseURI) {
        if (uri == null) {
            log.debug((Object)"quick fail, uri == null");
            return false;
        }
        String uriNodeValue = uri.getNodeValue();
        if (uriNodeValue.equals("") || uriNodeValue.charAt(0) == '#') {
            log.debug((Object)"quick fail for empty URIs and local ones");
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("I was asked whether I can resolve " + uriNodeValue));
        }
        if (uriNodeValue.startsWith("http:") || BaseURI != null && BaseURI.startsWith("http:")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("I state that I can resolve " + uriNodeValue));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("I state that I can't resolve " + uriNodeValue));
        }
        return false;
    }

    public String[] engineGetPropertyKeys() {
        return (String[])properties.clone();
    }

    private URI getNewURI(String uri, String BaseURI) throws URI.MalformedURIException {
        if (BaseURI == null || "".equals(BaseURI)) {
            return new URI(uri);
        }
        return new URI(new URI(BaseURI), uri);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

