/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.math.BigInteger;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class ElementProxy {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$utils$ElementProxy == null ? (class$org$apache$xml$security$utils$ElementProxy = ElementProxy.class$("org.apache.xml.security.utils.ElementProxy")) : class$org$apache$xml$security$utils$ElementProxy).getName());
    public static final int MODE_CREATE = 0;
    public static final int MODE_PROCESS = 1;
    public static final int MODE_UNKNOWN = 2;
    public static final int MODE_SIGN = 0;
    public static final int MODE_VERIFY = 1;
    public static final int MODE_ENCRYPT = 0;
    public static final int MODE_DECRYPT = 1;
    protected int _state = 2;
    protected Element _constructionElement = null;
    protected String _baseURI = null;
    protected Document _doc = null;
    static HashMap _prefixMappings = new HashMap();
    static HashMap _prefixMappingsBindings = new HashMap();
    static /* synthetic */ Class class$org$apache$xml$security$utils$ElementProxy;

    public abstract String getBaseNamespace();

    public abstract String getBaseLocalName();

    public ElementProxy() {
    }

    public ElementProxy(Document doc) {
        if (doc == null) {
            throw new RuntimeException("Document is null");
        }
        this._doc = doc;
        this._state = 0;
        this._constructionElement = this.createElementForFamilyLocal(this._doc, this.getBaseNamespace(), this.getBaseLocalName());
    }

    protected Element createElementForFamilyLocal(Document doc, String namespace, String localName) {
        Element result = null;
        if (namespace == null) {
            result = doc.createElementNS(null, localName);
        } else {
            String baseName = this.getBaseNamespace();
            String prefix = ElementProxy.getDefaultPrefix(baseName);
            if (prefix == null || prefix.length() == 0) {
                result = doc.createElementNS(namespace, localName);
                result.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespace);
            } else {
                String tagName = null;
                String defaultPrefixNaming = ElementProxy.getDefaultPrefixBindings(baseName);
                StringBuffer sb = new StringBuffer(prefix);
                sb.append(':');
                sb.append(localName);
                tagName = sb.toString();
                result = doc.createElementNS(namespace, tagName);
                result.setAttributeNS("http://www.w3.org/2000/xmlns/", defaultPrefixNaming, namespace);
            }
        }
        return result;
    }

    public static Element createElementForFamily(Document doc, String namespace, String localName) {
        Element result = null;
        String prefix = ElementProxy.getDefaultPrefix(namespace);
        if (namespace == null) {
            result = doc.createElementNS(null, localName);
        } else if (prefix == null || prefix.length() == 0) {
            result = doc.createElementNS(namespace, localName);
            result.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespace);
        } else {
            result = doc.createElementNS(namespace, prefix + ":" + localName);
            result.setAttributeNS("http://www.w3.org/2000/xmlns/", ElementProxy.getDefaultPrefixBindings(namespace), namespace);
        }
        return result;
    }

    public void setElement(Element element, String BaseURI) throws XMLSecurityException {
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setElement(" + element.getTagName() + ", \"" + BaseURI + "\""));
        }
        this._doc = element.getOwnerDocument();
        this._state = 1;
        this._constructionElement = element;
        this._baseURI = BaseURI;
    }

    public ElementProxy(Element element, String BaseURI) throws XMLSecurityException {
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setElement(\"" + element.getTagName() + "\", \"" + BaseURI + "\")"));
        }
        this._doc = element.getOwnerDocument();
        this._state = 1;
        this._constructionElement = element;
        this._baseURI = BaseURI;
        this.guaranteeThatElementInCorrectSpace();
    }

    public final Element getElement() {
        return this._constructionElement;
    }

    public final NodeList getElementPlusReturns() {
        HelperNodeList nl = new HelperNodeList();
        nl.appendChild(this._doc.createTextNode("\n"));
        nl.appendChild(this.getElement());
        nl.appendChild(this._doc.createTextNode("\n"));
        return nl;
    }

    public Document getDocument() {
        return this._doc;
    }

    public String getBaseURI() {
        return this._baseURI;
    }

    public void guaranteeThatElementInCorrectSpace() throws XMLSecurityException {
        String localnameSHOULDBE = this.getBaseLocalName();
        String namespaceSHOULDBE = this.getBaseNamespace();
        String localnameIS = this._constructionElement.getLocalName();
        String namespaceIS = this._constructionElement.getNamespaceURI();
        if (namespaceSHOULDBE != namespaceIS || !localnameSHOULDBE.equals(localnameIS)) {
            Object[] exArgs = new Object[]{namespaceIS + ":" + localnameIS, namespaceSHOULDBE + ":" + localnameSHOULDBE};
            throw new XMLSecurityException("xml.WrongElement", exArgs);
        }
    }

    public void addBigIntegerElement(BigInteger bi, String localname) {
        if (bi != null) {
            Element e = XMLUtils.createElementInSignatureSpace(this._doc, localname);
            Base64.fillElementWithBigInteger(e, bi);
            this._constructionElement.appendChild(e);
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addBase64Element(byte[] bytes, String localname) {
        if (bytes != null) {
            Element e = Base64.encodeToElement(this._doc, localname, bytes);
            this._constructionElement.appendChild(e);
            this._constructionElement.appendChild(this._doc.createTextNode("\n"));
        }
    }

    public void addTextElement(String text, String localname) {
        Element e = XMLUtils.createElementInSignatureSpace(this._doc, localname);
        Text t = this._doc.createTextNode(text);
        e.appendChild(t);
        this._constructionElement.appendChild(e);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addBase64Text(byte[] bytes) {
        if (bytes != null) {
            Text t = this._doc.createTextNode("\n" + Base64.encode(bytes) + "\n");
            this._constructionElement.appendChild(t);
        }
    }

    public void addText(String text) {
        if (text != null) {
            Text t = this._doc.createTextNode(text);
            this._constructionElement.appendChild(t);
        }
    }

    public BigInteger getBigIntegerFromChildElement(String localname, String namespace) throws Base64DecodingException {
        return Base64.decodeBigIntegerFromText(XMLUtils.selectNodeText(this._constructionElement.getFirstChild(), namespace, localname, 0));
    }

    public byte[] getBytesFromChildElement(String localname, String namespace) throws XMLSecurityException {
        Element e = XMLUtils.selectNode(this._constructionElement.getFirstChild(), namespace, localname, 0);
        return Base64.decode(e);
    }

    public String getTextFromChildElement(String localname, String namespace) {
        Text t = (Text)XMLUtils.selectNode(this._constructionElement.getFirstChild(), namespace, localname, 0).getFirstChild();
        return t.getData();
    }

    public byte[] getBytesFromTextChild() throws XMLSecurityException {
        Text t = (Text)this._constructionElement.getFirstChild();
        return Base64.decode(t.getData());
    }

    public String getTextFromTextChild() {
        return XMLUtils.getFullTextChildrenFromElement(this._constructionElement);
    }

    public int length(String namespace, String localname) {
        int number = 0;
        for (Node sibling = this._constructionElement.getFirstChild(); sibling != null; sibling = sibling.getNextSibling()) {
            if (!localname.equals(sibling.getLocalName()) || namespace != sibling.getNamespaceURI()) continue;
            ++number;
        }
        return number;
    }

    public void setXPathNamespaceContext(String prefix, String uri) throws XMLSecurityException {
        if (prefix == null || prefix.length() == 0) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        if (prefix.equals("xmlns")) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        String ns = prefix.startsWith("xmlns:") ? prefix : "xmlns:" + prefix;
        Attr a = this._constructionElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", ns);
        if (a != null) {
            if (!a.getNodeValue().equals(uri)) {
                Object[] exArgs = new Object[]{ns, this._constructionElement.getAttributeNS(null, ns)};
                throw new XMLSecurityException("namespacePrefixAlreadyUsedByOtherURI", exArgs);
            }
            return;
        }
        this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", ns, uri);
    }

    public static void setDefaultPrefix(String namespace, String prefix) throws XMLSecurityException {
        Object storedNamespace;
        if (_prefixMappings.containsValue(prefix) && !(storedNamespace = _prefixMappings.get(namespace)).equals(prefix)) {
            Object[] exArgs = new Object[]{prefix, namespace, storedNamespace};
            throw new XMLSecurityException("prefix.AlreadyAssigned", exArgs);
        }
        if ("http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
            XMLUtils.dsPrefix = prefix;
            XMLUtils.xmlnsDsPrefix = "xmlns:" + prefix;
        }
        _prefixMappings.put(namespace, prefix.intern());
        _prefixMappingsBindings.put(namespace, ("xmlns:" + prefix).intern());
    }

    public static String getDefaultPrefix(String namespace) {
        String prefix = (String)_prefixMappings.get(namespace);
        return prefix;
    }

    public static String getDefaultPrefixBindings(String namespace) {
        String prefix = (String)_prefixMappingsBindings.get(namespace);
        return prefix;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

