/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Transform
extends SignatureElementProxy {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$transforms$Transform == null ? (class$org$apache$xml$security$transforms$Transform = Transform.class$("org.apache.xml.security.transforms.Transform")) : class$org$apache$xml$security$transforms$Transform).getName());
    static boolean _alreadyInitialized = false;
    static Map _transformHash = null;
    static HashMap classesHash = new HashMap();
    protected TransformSpi transformSpi = null;
    static /* synthetic */ Class class$org$apache$xml$security$transforms$Transform;

    public Transform(Document doc, String algorithmURI, NodeList contextNodes) throws InvalidTransformException {
        super(doc);
        this._constructionElement.setAttributeNS(null, "Algorithm", algorithmURI);
        this.transformSpi = Transform.getImplementingClass(algorithmURI);
        if (this.transformSpi == null) {
            Object[] exArgs = new Object[]{algorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create URI \"" + algorithmURI + "\" class \"" + this.transformSpi.getClass() + "\""));
            log.debug((Object)("The NodeList is " + contextNodes));
        }
        if (contextNodes != null) {
            for (int i = 0; i < contextNodes.getLength(); ++i) {
                this._constructionElement.appendChild(contextNodes.item(i).cloneNode(true));
            }
        }
    }

    public Transform(Element element, String BaseURI) throws InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, BaseURI);
        String AlgorithmURI = element.getAttributeNS(null, "Algorithm");
        if (AlgorithmURI == null || AlgorithmURI.length() == 0) {
            Object[] exArgs = new Object[]{"Algorithm", "Transform"};
            throw new TransformationException("xml.WrongContent", exArgs);
        }
        this.transformSpi = Transform.getImplementingClass(AlgorithmURI);
        if (this.transformSpi == null) {
            Object[] exArgs = new Object[]{AlgorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
        }
    }

    public static final Transform getInstance(Document doc, String algorithmURI) throws InvalidTransformException {
        return Transform.getInstance(doc, algorithmURI, (NodeList)null);
    }

    public static final Transform getInstance(Document doc, String algorithmURI, Element contextChild) throws InvalidTransformException {
        HelperNodeList contextNodes = new HelperNodeList();
        contextNodes.appendChild(doc.createTextNode("\n"));
        contextNodes.appendChild(contextChild);
        contextNodes.appendChild(doc.createTextNode("\n"));
        return Transform.getInstance(doc, algorithmURI, contextNodes);
    }

    public static final Transform getInstance(Document doc, String algorithmURI, NodeList contextNodes) throws InvalidTransformException {
        return new Transform(doc, algorithmURI, contextNodes);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _transformHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String algorithmURI, String implementingClass) throws AlgorithmAlreadyRegisteredException {
        TransformSpi registeredClass = null;
        try {
            registeredClass = Transform.getImplementingClass(algorithmURI);
        }
        catch (InvalidTransformException e1) {
            Object[] exArgs = new Object[]{algorithmURI, registeredClass};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", exArgs);
        }
        if (registeredClass != null) {
            Object[] exArgs = new Object[]{algorithmURI, registeredClass};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", exArgs);
        }
        try {
            _transformHash.put(algorithmURI, Class.forName(implementingClass));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public XMLSignatureInput performTransform(XMLSignatureInput input) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput result = null;
        try {
            result = this.transformSpi.enginePerformTransform(input, this);
        }
        catch (ParserConfigurationException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        catch (SAXException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        return result;
    }

    public XMLSignatureInput performTransform(XMLSignatureInput input, OutputStream os) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput result = null;
        try {
            result = this.transformSpi.enginePerformTransform(input, os, this);
        }
        catch (ParserConfigurationException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        catch (SAXException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        return result;
    }

    private static TransformSpi getImplementingClass(String URI2) throws InvalidTransformException {
        try {
            Object value = classesHash.get(URI2);
            if (value != null) {
                return (TransformSpi)value;
            }
            Class cl = (Class)_transformHash.get(URI2);
            if (cl != null) {
                TransformSpi tr = (TransformSpi)cl.newInstance();
                classesHash.put(URI2, tr);
                return tr;
            }
        }
        catch (InstantiationException ex) {
            Object[] exArgs = new Object[]{URI2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs, ex);
        }
        catch (IllegalAccessException ex) {
            Object[] exArgs = new Object[]{URI2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs, ex);
        }
        return null;
    }

    public String getBaseLocalName() {
        return "Transform";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

