/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.w3c.dom.Element;

public class KeyResolver {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$keys$keyresolver$KeyResolver == null ? (class$org$apache$xml$security$keys$keyresolver$KeyResolver = KeyResolver.class$("org.apache.xml.security.keys.keyresolver.KeyResolver")) : class$org$apache$xml$security$keys$keyresolver$KeyResolver).getName());
    static boolean _alreadyInitialized = false;
    static List _resolverVector = null;
    protected KeyResolverSpi _resolverSpi = null;
    protected StorageResolver _storage = null;
    static /* synthetic */ Class class$org$apache$xml$security$keys$keyresolver$KeyResolver;

    private KeyResolver(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._resolverSpi = (KeyResolverSpi)Class.forName(className).newInstance();
        this._resolverSpi.setGlobalResolver(true);
    }

    public static int length() {
        return _resolverVector.size();
    }

    public static KeyResolverSpi item(int i) throws KeyResolverException {
        KeyResolver resolver = (KeyResolver)_resolverVector.get(i);
        if (resolver == null) {
            throw new KeyResolverException("utils.resolver.noClass");
        }
        return resolver._resolverSpi;
    }

    public static void hit(int i) {
        if (i != 0) {
            List resolverVector = (List)((ArrayList)_resolverVector).clone();
            Object ob = resolverVector.remove(i);
            resolverVector.add(0, ob);
            _resolverVector = resolverVector;
        }
    }

    public static final X509Certificate getX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        for (int i = 0; i < _resolverVector.size(); ++i) {
            X509Certificate cert;
            KeyResolver resolver = (KeyResolver)_resolverVector.get(i);
            if (resolver == null) {
                Object[] exArgs = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", exArgs);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("check resolvability by class " + resolver.getClass()));
            }
            if ((cert = resolver.resolveX509Certificate(element, BaseURI, storage)) == null) continue;
            return cert;
        }
        Object[] exArgs = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", exArgs);
    }

    public static final PublicKey getPublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        for (int i = 0; i < _resolverVector.size(); ++i) {
            PublicKey cert;
            KeyResolver resolver = (KeyResolver)_resolverVector.get(i);
            if (resolver == null) {
                Object[] exArgs = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", exArgs);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("check resolvability by class " + resolver.getClass()));
            }
            if ((cert = resolver.resolvePublicKey(element, BaseURI, storage)) == null) continue;
            if (i != 0) {
                List resolverVector = (List)((ArrayList)_resolverVector).clone();
                Object ob = resolverVector.remove(i);
                resolverVector.add(0, ob);
                _resolverVector = resolverVector;
            }
            return cert;
        }
        Object[] exArgs = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", exArgs);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _resolverVector = new ArrayList(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        _resolverVector.add(new KeyResolver(className));
    }

    public static void registerAtStart(String className) {
        _resolverVector.add(0, className);
    }

    public PublicKey resolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return this._resolverSpi.engineLookupAndResolvePublicKey(element, BaseURI, storage);
    }

    public X509Certificate resolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return this._resolverSpi.engineLookupResolveX509Certificate(element, BaseURI, storage);
    }

    public SecretKey resolveSecretKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return this._resolverSpi.engineLookupAndResolveSecretKey(element, BaseURI, storage);
    }

    public void setProperty(String key, String value) {
        this._resolverSpi.engineSetProperty(key, value);
    }

    public String getProperty(String key) {
        return this._resolverSpi.engineGetProperty(key);
    }

    public boolean understandsProperty(String propertyToTest) {
        return this._resolverSpi.understandsProperty(propertyToTest);
    }

    public String resolverClassName() {
        return this._resolverSpi.getClass().getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

