/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.saml.util;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLUtil {
    private static Logger logger = Logger.getLogger("javax.enterprise.resource.xml.webservices.security.saml", "com.sun.xml.wss.logging.saml.LogStrings");

    public static Element locateSamlAssertion(String assertionId, Document soapDocument) throws XWSSecurityException {
        NodeList nodeList = null;
        try {
            nodeList = soapDocument.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        int nodeListLength = nodeList.getLength();
        if (nodeListLength == 0) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "WSS001.SAML_ASSERTION_NOT_FOUND", new Object[]{assertionId});
            }
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", null);
        }
        for (int i = 0; i < nodeListLength; ++i) {
            Element assertion = (Element)nodeList.item(i);
            String aId = assertion.getAttribute("AssertionID");
            if (!aId.equals(assertionId)) continue;
            return assertion;
        }
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, "WSS001.SAML_ASSERTION_NOT_FOUND", new Object[]{assertionId});
        }
        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", null);
    }

    public static Element toElement(Node doc, Object element) throws XWSSecurityException {
        Element el;
        DOMResult result = null;
        Document document = null;
        if (doc != null) {
            result = new DOMResult(doc);
        } else {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.newDocument();
            }
            catch (Exception ex) {
                throw new XWSSecurityException("Unable to create Document : " + ex.getMessage());
            }
            result = new DOMResult(document);
        }
        try {
            JAXBContext jc = null;
            jc = System.getProperty("com.sun.xml.wss.saml.binding.jaxb") == null ? JAXBContext.newInstance((String)"com.sun.xml.wss.saml.internal.saml11.jaxb20") : JAXBContext.newInstance((String)"com.sun.xml.wss.saml.internal.saml11.jaxb10");
            Marshaller m = jc.createMarshaller();
            m.marshal(element, (Result)result);
        }
        catch (Exception ex) {
            throw new XWSSecurityException("Not able to Marshal " + element.getClass().getName() + ", got exception: " + ex.getMessage());
        }
        if (doc != null) {
            if (doc.getNodeType() == 1) {
                el = (Element)((Element)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion").item(0);
                return el;
            }
            el = (Element)((Document)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion").item(0);
            return el;
        }
        el = (Element)document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion").item(0);
        return el;
    }
}

