/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.SubjectAccessor;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.Timestamp;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import com.sun.xml.wss.impl.callback.DecryptionKeyCallback;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.callback.EncryptionKeyCallback;
import com.sun.xml.wss.impl.callback.PasswordCallback;
import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureVerificationKeyCallback;
import com.sun.xml.wss.impl.callback.TimestampValidationCallback;
import com.sun.xml.wss.impl.callback.UsernameCallback;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.misc.NonceCache;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.saml.Assertion;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultSecurityEnvironmentImpl
implements SecurityEnvironment {
    static final boolean USE_DAEMON_THREAD = true;
    static final Timer nonceCleanupTimer = new Timer(true);
    private static final long offset;
    NonceCache nonceCache = null;
    protected static Logger log;
    private final SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'sss'Z'");
    CallbackHandler callbackHandler = null;

    public DefaultSecurityEnvironmentImpl(CallbackHandler cHandler) {
        this.callbackHandler = cHandler;
    }

    public X509Certificate getDefaultCertificate(Map context) throws XWSSecurityException {
        X509Certificate defaultCert = null;
        SignatureKeyCallback.DefaultPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.DefaultPrivKeyCertRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        defaultCert = privKeyRequest.getX509Certificate();
        if (defaultCert == null) {
            log.log(Level.SEVERE, "WSS0218.cannot.locate.default.cert");
            throw new XWSSecurityException("Unable to locate a default certificate");
        }
        return defaultCert;
    }

    public SignatureKeyCallback.PrivKeyCertRequest getDefaultPrivKeyCertRequest(Map context) throws XWSSecurityException {
        SignatureKeyCallback.DefaultPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.DefaultPrivKeyCertRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        return privKeyRequest;
    }

    public SignatureKeyCallback.AliasPrivKeyCertRequest getAliasPrivKeyCertRequest(String certIdentifier) throws XWSSecurityException {
        SignatureKeyCallback.AliasPrivKeyCertRequest request = new SignatureKeyCallback.AliasPrivKeyCertRequest(certIdentifier);
        SignatureKeyCallback sigCallback = new SignatureKeyCallback(request);
        Callback[] callback = new Callback[]{sigCallback};
        try {
            this.callbackHandler.handle(callback);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.AliasPrivKeyCertRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        return request;
    }

    public PrivateKey getDefaultPrivateKey(Map context) throws XWSSecurityException {
        PrivateKey defaultPrivKey = null;
        SignatureKeyCallback.DefaultPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.DefaultPrivKeyCertRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        defaultPrivKey = privKeyRequest.getPrivateKey();
        if (defaultPrivKey == null) {
            log.log(Level.SEVERE, "WSS0219.cannot.locate.default.privkey");
            throw new XWSSecurityException("Unable to locate a default certificate");
        }
        return defaultPrivKey;
    }

    public SecretKey getSecretKey(Map context, String alias, boolean encryptMode) throws XWSSecurityException {
        SecretKey symmetricKey = null;
        if (encryptMode) {
            EncryptionKeyCallback.AliasSymmetricKeyRequest symmKeyRequest = new EncryptionKeyCallback.AliasSymmetricKeyRequest(alias);
            EncryptionKeyCallback encKeyCallback = new EncryptionKeyCallback(symmKeyRequest);
            ProcessingContext.copy(encKeyCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{encKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"EncryptionKeyCallback.AliasSymmetricKeyRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            symmetricKey = symmKeyRequest.getSymmetricKey();
        } else {
            DecryptionKeyCallback.AliasSymmetricKeyRequest symmKeyRequest = new DecryptionKeyCallback.AliasSymmetricKeyRequest(alias);
            DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(symmKeyRequest);
            ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{decryptKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.AliasSymmetricKeyRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            symmetricKey = symmKeyRequest.getSymmetricKey();
        }
        if (symmetricKey == null) {
            log.log(Level.SEVERE, "WSS0220.cannot.locate.symmetrickey.for.decrypt");
            throw new XWSSecurityException("Could not locate the symmetric key for alias " + alias);
        }
        return symmetricKey;
    }

    public X509Certificate getCertificate(Map context, String alias, boolean forSigning) throws XWSSecurityException {
        Object certRequest;
        X509Certificate cert = null;
        if (alias == null && forSigning) {
            return this.getDefaultCertificate(context);
        }
        if (forSigning) {
            certRequest = new SignatureKeyCallback.AliasPrivKeyCertRequest(alias);
            SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback((SignatureKeyCallback.Request)certRequest);
            ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{sigKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.AliasPrivKeyCertRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            cert = ((SignatureKeyCallback.PrivKeyCertRequest)certRequest).getX509Certificate();
        } else {
            certRequest = new EncryptionKeyCallback.AliasX509CertificateRequest(alias);
            EncryptionKeyCallback encKeyCallback = new EncryptionKeyCallback((EncryptionKeyCallback.Request)certRequest);
            ProcessingContext.copy(encKeyCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{encKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"EncryptionKeyCallback.AliasX509CertificateRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            cert = ((EncryptionKeyCallback.X509CertificateRequest)certRequest).getX509Certificate();
        }
        if (cert == null) {
            String val = forSigning ? "Signature" : "Key Ecnryption";
            log.log(Level.SEVERE, "WSS0221.cannot.locate.cert", new Object[]{val});
            throw new XWSSecurityException("Unable to locate certificate for the alias " + alias);
        }
        return cert;
    }

    public X509Certificate getCertificate(Map context, PublicKey publicKey, boolean forSign) throws XWSSecurityException {
        if (forSign) {
            SignatureVerificationKeyCallback.PublicKeyBasedRequest pubKeyReq = new SignatureVerificationKeyCallback.PublicKeyBasedRequest(publicKey);
            SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(pubKeyReq);
            ProcessingContext.copy(verifyKeyCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{verifyKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (UnsupportedCallbackException e1) {
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureVerificationKeyCallback.PublicKeyBasedRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            return pubKeyReq.getX509Certificate();
        }
        EncryptionKeyCallback.PublicKeyBasedRequest pubKeyReq = new EncryptionKeyCallback.PublicKeyBasedRequest(publicKey);
        EncryptionKeyCallback encCallback = new EncryptionKeyCallback(pubKeyReq);
        ProcessingContext.copy(encCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{encCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e1) {
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"EncryptionKeyCallback.PublicKeyBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        return pubKeyReq.getX509Certificate();
    }

    public PrivateKey getPrivateKey(Map context, String alias) throws XWSSecurityException {
        PrivateKey privKey = null;
        if (alias == null) {
            return this.getDefaultPrivateKey(context);
        }
        SignatureKeyCallback.AliasPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.AliasPrivKeyCertRequest(alias);
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.AliasPrivKeyCertRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        privKey = privKeyRequest.getPrivateKey();
        if (privKey == null) {
            log.log(Level.SEVERE, "WSS0222.cannot.locate.privkey", new Object[]{alias});
            throw new XWSSecurityException("Unable to locate private key for the alias " + alias);
        }
        return privKey;
    }

    public PrivateKey getPrivateKey(Map context, byte[] keyIdentifier) throws XWSSecurityException {
        PrivateKey privateKey = null;
        DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest privKeyRequest = new DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest(keyIdentifier);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privKeyRequest);
        ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        privateKey = privKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, "WSS0222.cannot.locate.privkey", new Object[]{keyIdentifier});
            throw new XWSSecurityException("No Matching private key for " + Base64.encode(keyIdentifier) + " subject key identifier found");
        }
        return privateKey;
    }

    public PrivateKey getPrivateKey(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        PrivateKey privateKey = null;
        DecryptionKeyCallback.X509IssuerSerialBasedRequest privKeyRequest = new DecryptionKeyCallback.X509IssuerSerialBasedRequest(issuerName, serialNumber);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privKeyRequest);
        ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.X509IssuerSerialBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        privateKey = privKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, "WSS0222.cannot.locate.privkey", new Object[]{serialNumber + ":" + issuerName});
            throw new XWSSecurityException("No Matching private key for serial number " + serialNumber + " and issuer name " + issuerName + " found");
        }
        return privateKey;
    }

    public PublicKey getPublicKey(Map context, byte[] keyIdentifier) throws XWSSecurityException {
        return this.getCertificate(context, keyIdentifier).getPublicKey();
    }

    public X509Certificate getCertificate(Map context, byte[] keyIdentifier) throws XWSSecurityException {
        X509Certificate cert = null;
        SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest certRequest = new SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest(keyIdentifier);
        SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(certRequest);
        ProcessingContext.copy(verifyKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{verifyKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        cert = certRequest.getX509Certificate();
        if (cert == null) {
            log.log(Level.SEVERE, "WSS0221.cannot.locate.cert", new Object[]{keyIdentifier});
            throw new XWSSecurityException("No Matching public key for " + Base64.encode(keyIdentifier) + " subject key identifier found");
        }
        return cert;
    }

    public PublicKey getPublicKey(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        return this.getCertificate(context, serialNumber, issuerName).getPublicKey();
    }

    public X509Certificate getCertificate(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        X509Certificate cert = null;
        SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest certRequest = new SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest(issuerName, serialNumber);
        SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(certRequest);
        ProcessingContext.copy(verifyKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{verifyKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        cert = certRequest.getX509Certificate();
        if (cert == null) {
            log.log(Level.SEVERE, "WSS0221.cannot.locate.cert", new Object[]{serialNumber + ":" + issuerName});
            throw new XWSSecurityException("No Matching public key for serial number " + serialNumber + " and issuer name " + issuerName + " found");
        }
        return cert;
    }

    public boolean validateCertificate(X509Certificate cert) throws XWSSecurityException {
        CertificateValidationCallback certValCallback = new CertificateValidationCallback(cert);
        Callback[] callbacks = new Callback[]{certValCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Certificate validation failed", e);
        }
        return certValCallback.getResult();
    }

    public void updateOtherPartySubject(final Subject subject, final String username, final String password) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String x500Name = "CN=" + username;
                X500Principal principal = new X500Principal(x500Name);
                subject.getPrincipals().add(principal);
                if (password != null) {
                    subject.getPrivateCredentials().add(password);
                }
                return null;
            }
        });
    }

    public void updateOtherPartySubject(final Subject subject, final X509Certificate cert) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                X500Principal principal = cert.getSubjectX500Principal();
                subject.getPrincipals().add(principal);
                subject.getPublicCredentials().add(cert);
                return null;
            }
        });
    }

    public void updateOtherPartySubject(final Subject subject, final Assertion assertion) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                subject.getPublicCredentials().add(assertion);
                return null;
            }
        });
    }

    public static Subject getSubject(final FilterProcessingContext context) {
        Subject otherPartySubject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject otherPartySubject = (Subject)context.getExtraneousProperty("javax.security.auth.Subject");
                if (otherPartySubject == null) {
                    otherPartySubject = new Subject();
                    context.setExtraneousProperty("javax.security.auth.Subject", otherPartySubject);
                    SubjectAccessor.setRequesterSubject(otherPartySubject);
                }
                return otherPartySubject;
            }
        });
        return otherPartySubject;
    }

    public PrivateKey getPrivateKey(Map context, X509Certificate cert) throws XWSSecurityException {
        PrivateKey privateKey = null;
        DecryptionKeyCallback.X509CertificateBasedRequest privateKeyRequest = new DecryptionKeyCallback.X509CertificateBasedRequest(cert);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privateKeyRequest);
        ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.X509CertificateBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        privateKey = privateKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, "WSS0222.cannot.locate.privkey", new Object[]{"given certificate"});
            throw new XWSSecurityException("Could not retrieve private Key matching the given certificate");
        }
        return privateKey;
    }

    public PrivateKey getPrivateKey(Map context, PublicKey publicKey, boolean forSign) throws XWSSecurityException {
        if (forSign) {
            SignatureKeyCallback.PublicKeyBasedPrivKeyCertRequest req = new SignatureKeyCallback.PublicKeyBasedPrivKeyCertRequest(publicKey);
            SignatureKeyCallback skc = new SignatureKeyCallback(req);
            ProcessingContext.copy(skc.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{skc};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.PublicKeyBasedPrivKeyCertRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            return req.getPrivateKey();
        }
        DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest req = new DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest(publicKey);
        DecryptionKeyCallback dkc = new DecryptionKeyCallback(req);
        ProcessingContext.copy(dkc.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{dkc};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        return req.getPrivateKey();
    }

    public Subject getSubject() {
        throw new UnsupportedOperationException("This environment does not have an associated Subject");
    }

    public boolean authenticateUser(Map context, String username, String passwordDigest, String nonce, String created) throws XWSSecurityException {
        PasswordValidationCallback.DigestPasswordRequest request = new PasswordValidationCallback.DigestPasswordRequest(username, passwordDigest, nonce, created);
        PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(request);
        ProcessingContext.copy(passwordValidationCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{passwordValidationCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        return passwordValidationCallback.getResult();
    }

    public boolean authenticateUser(Map context, String username, String password) throws XWSSecurityException {
        PasswordValidationCallback.PlainTextPasswordRequest request = new PasswordValidationCallback.PlainTextPasswordRequest(username, password);
        PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(request);
        ProcessingContext.copy(passwordValidationCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{passwordValidationCallback};
        boolean result = false;
        try {
            this.callbackHandler.handle(callbacks);
            result = passwordValidationCallback.getResult();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultValidateCreationTime(String creationTime, long maxClockSkew, long timestampFreshnessLimit) throws XWSSecurityException {
        Date created = null;
        try {
            try {
                SimpleDateFormat simpleDateFormat = this.calendarFormatter1;
                synchronized (simpleDateFormat) {
                    created = this.calendarFormatter1.parse(creationTime);
                }
            }
            catch (ParseException e) {
                SimpleDateFormat simpleDateFormat = this.calendarFormatter2;
                synchronized (simpleDateFormat) {
                    created = this.calendarFormatter2.parse(creationTime);
                }
            }
        }
        catch (ParseException e) {
            throw new XWSSecurityException(e);
        }
        Date current = DefaultSecurityEnvironmentImpl.getFreshnessAndSkewAdjustedDate(maxClockSkew, timestampFreshnessLimit);
        if (created.before(current)) {
            throw new XWSSecurityException("The creation time is older than  currenttime - timestamp-freshness-limit - max-clock-skew");
        }
        Date currentTime = DefaultSecurityEnvironmentImpl.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, true);
        if (currentTime.before(created)) {
            throw new XWSSecurityException("The creation time is ahead of the current time.");
        }
    }

    public void validateCreationTime(Map context, String creationTime, long maxClockSkew, long timestampFreshnessLimit) throws XWSSecurityException {
        TimestampValidationCallback.UTCTimestampRequest request = new TimestampValidationCallback.UTCTimestampRequest(creationTime, null, maxClockSkew, timestampFreshnessLimit);
        request.isUsernameToken(true);
        TimestampValidationCallback timestampValidationCallback = new TimestampValidationCallback(request);
        ProcessingContext.copy(timestampValidationCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{timestampValidationCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            this.defaultValidateCreationTime(creationTime, maxClockSkew, timestampFreshnessLimit);
            return;
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        try {
            timestampValidationCallback.getResult();
        }
        catch (TimestampValidationCallback.TimestampValidationException e) {
            throw new XWSSecurityException(e);
        }
    }

    public boolean validateSamlIssuer(String issuer) {
        throw new UnsupportedOperationException();
    }

    public boolean validateSamlUser(String user, String domain, String format) {
        throw new UnsupportedOperationException();
    }

    public String getUsername(Map context) throws XWSSecurityException {
        UsernameCallback usernameCallback = new UsernameCallback();
        ProcessingContext.copy(usernameCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{usernameCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"UsernameCallback"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        return usernameCallback.getUsername();
    }

    public String getPassword(Map context) throws XWSSecurityException {
        PasswordCallback passwordCallback = new PasswordCallback();
        ProcessingContext.copy(passwordCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{passwordCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e.getMessage(), e);
        }
        return passwordCallback.getPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultValidateExpirationTime(String expirationTime, long maxClockSkew, long timestampFreshnessLimit) throws XWSSecurityException {
        if (expirationTime != null) {
            Date expires;
            try {
                try {
                    SimpleDateFormat simpleDateFormat = this.calendarFormatter1;
                    synchronized (simpleDateFormat) {
                        expires = this.calendarFormatter1.parse(expirationTime);
                    }
                }
                catch (ParseException pe) {
                    SimpleDateFormat simpleDateFormat = this.calendarFormatter2;
                    synchronized (simpleDateFormat) {
                        expires = this.calendarFormatter2.parse(expirationTime);
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0394.error.parsing.expirationtime");
                throw new XWSSecurityException(e);
            }
            Date currentTime = DefaultSecurityEnvironmentImpl.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, false);
            if (expires.before(currentTime)) {
                log.log(Level.SEVERE, "WSS0393.current.ahead.of.expires");
                throw new XWSSecurityException("The current time is ahead of the expiration time in Timestamp");
            }
        }
    }

    public void validateTimestamp(Map context, Timestamp timestamp, long maxClockSkew, long freshnessLimit) throws XWSSecurityException {
        if (this.expiresBeforeCreated(timestamp.getCreated(), timestamp.getExpires())) {
            XWSSecurityException xwsse = new XWSSecurityException("Message expired!");
            throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSU_MESSAGE_EXPIRED, "Message expired!", xwsse);
        }
        TimestampValidationCallback.UTCTimestampRequest request = new TimestampValidationCallback.UTCTimestampRequest(timestamp.getCreated(), timestamp.getExpires(), maxClockSkew, freshnessLimit);
        TimestampValidationCallback timestampValidationCallback = new TimestampValidationCallback(request);
        ProcessingContext.copy(timestampValidationCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{timestampValidationCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            this.defaultValidateCreationTime(timestamp.getCreated(), maxClockSkew, freshnessLimit);
            this.defaultValidateExpirationTime(timestamp.getExpires(), maxClockSkew, freshnessLimit);
            return;
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        try {
            timestampValidationCallback.getResult();
        }
        catch (TimestampValidationCallback.TimestampValidationException e) {
            throw new XWSSecurityException(e);
        }
    }

    public static WssSoapFaultException newSOAPFaultException(QName faultCode, String faultstring, Throwable th) {
        WssSoapFaultException sfe = new WssSoapFaultException(faultCode, faultstring, null, null);
        sfe.initCause(th);
        return sfe;
    }

    private static Date getGMTDateWithSkewAdjusted(Calendar c, long maxClockSkew, boolean addSkew) {
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        currentTime = addSkew ? (currentTime += maxClockSkew) : (currentTime -= maxClockSkew);
        c.setTimeInMillis(currentTime);
        return c.getTime();
    }

    private static Date getFreshnessAndSkewAdjustedDate(long maxClockSkew, long timestampFreshnessLimit) {
        GregorianCalendar c = new GregorianCalendar();
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        long adjustedTime = currentTime - maxClockSkew - timestampFreshnessLimit;
        c.setTimeInMillis(adjustedTime);
        return c.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expiresBeforeCreated(String creationTime, String expirationTime) throws XWSSecurityException {
        Date created = null;
        Date expires = null;
        try {
            try {
                SimpleDateFormat simpleDateFormat = this.calendarFormatter1;
                synchronized (simpleDateFormat) {
                    created = this.calendarFormatter1.parse(creationTime);
                    if (expirationTime != null) {
                        expires = this.calendarFormatter1.parse(expirationTime);
                    }
                }
            }
            catch (ParseException pe) {
                SimpleDateFormat simpleDateFormat = this.calendarFormatter2;
                synchronized (simpleDateFormat) {
                    created = this.calendarFormatter2.parse(creationTime);
                    if (expirationTime != null) {
                        expires = this.calendarFormatter2.parse(expirationTime);
                    }
                }
            }
        }
        catch (ParseException pe) {
            throw new XWSSecurityException(pe.getMessage());
        }
        if (expires != null && expires.equals(created)) {
            return true;
        }
        return expires != null && expires.before(created);
    }

    public boolean validateAndCacheNonce(String nonce, String created, long maxNonceAge) throws XWSSecurityException {
        if (this.nonceCache == null || this.nonceCache != null && this.nonceCache.wasCanceled()) {
            this.initNonceCache(maxNonceAge);
        }
        if (!this.nonceCache.isScheduled()) {
            this.setNonceCacheCleanup();
        }
        return this.nonceCache.validateAndCacheNonce(nonce, created);
    }

    public void validateSAMLAssertion(Map context, Element assertion) throws XWSSecurityException {
        AuthenticationTokenPolicy authPolicy = new AuthenticationTokenPolicy();
        AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)authPolicy.newSAMLAssertionFeatureBinding();
        samlPolicy.setAssertion(assertion);
        DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(samlPolicy, null);
        ProcessingContext.copy(dynamicCallback.getRuntimeProperties(), context);
        try {
            Callback[] callbacks = new Callback[]{dynamicCallback};
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Validation failed for SAML Assertion ID: " + ((Assertion)((Object)assertion)).getAssertionID(), e);
        }
    }

    public Element locateSAMLAssertion(Map context, Element binding, String assertionId, Document ownerDoc) throws XWSSecurityException {
        AuthenticationTokenPolicy authPolicy = new AuthenticationTokenPolicy();
        AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)authPolicy.newSAMLAssertionFeatureBinding();
        samlPolicy.setAuthorityBinding(binding);
        samlPolicy.setAssertionId(assertionId);
        DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(samlPolicy, null);
        ProcessingContext.copy(dynamicCallback.getRuntimeProperties(), context);
        try {
            Callback[] callbacks = new Callback[]{dynamicCallback};
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        Element assertion = samlPolicy.getAssertion();
        if (assertion == null) {
            throw new XWSSecurityException("SAML Assertion not set into Policy by CallbackHandler");
        }
        return assertion;
    }

    public AuthenticationTokenPolicy.SAMLAssertionBinding populateSAMLPolicy(Map fpcontext, AuthenticationTokenPolicy.SAMLAssertionBinding policy, DynamicApplicationContext context) throws XWSSecurityException {
        DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(policy, context);
        ProcessingContext.copy(dynamicCallback.getRuntimeProperties(), fpcontext);
        try {
            Callback[] callbacks = new Callback[]{dynamicCallback};
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        return (AuthenticationTokenPolicy.SAMLAssertionBinding)dynamicCallback.getSecurityPolicy();
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    private synchronized void initNonceCache(long maxNonceAge) {
        if (this.nonceCache == null) {
            this.nonceCache = maxNonceAge == 0L ? new NonceCache() : new NonceCache(maxNonceAge);
        } else if (this.nonceCache.wasCanceled()) {
            this.nonceCache = maxNonceAge == 0L ? new NonceCache() : new NonceCache(maxNonceAge);
        }
    }

    private synchronized void setNonceCacheCleanup() {
        if (!this.nonceCache.isScheduled()) {
            nonceCleanupTimer.schedule((TimerTask)this.nonceCache, this.nonceCache.getMaxNonceAge(), this.nonceCache.getMaxNonceAge());
            this.nonceCache.scheduled(true);
        }
    }

    private void validateSamlVersion(Assertion assertion) {
        BigInteger major = assertion.getMajorVersion();
        BigInteger minor = assertion.getMinorVersion();
        if (major.intValue() != 1) {
            log.log(Level.SEVERE, "WSS0404.saml.invalid.version");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Major version is not 1 for SAML Assertion:" + assertion.getAssertionID(), new Exception("Major version is not 1 for SAML Assertion"));
        }
        if (minor.intValue() != 0 && minor.intValue() != 1) {
            log.log(Level.SEVERE, "WSS0404.saml.invalid.version");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Minor version is not 0/1 for SAML Assertion:" + assertion.getAssertionID(), new Exception("Minor version is not 0/1 for SAML Assertion"));
        }
    }

    private void validateIssuer(SecurableSoapMessage secMessage, Assertion assertion) {
    }

    private void validateSamlUser(SecurableSoapMessage secMessage, Assertion assertion) {
        Object user = null;
    }

    static {
        GregorianCalendar c = new GregorianCalendar();
        long calculatedOffset = c.get(15);
        if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
            calculatedOffset += (long)((Calendar)c).getTimeZone().getDSTSavings();
        }
        offset = calculatedOffset;
        log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    }
}

