/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.HarnessUtil;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.dsig.SignatureProcessor;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.PrivateKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;

public class SignatureFilter {
    private static Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.filter", "com.sun.xml.wss.logging.impl.filter.LogStrings");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void process(FilterProcessingContext context) throws XWSSecurityException {
        if (!context.isInboundMessage()) {
            WSSPolicy policy = (WSSPolicy)context.getSecurityPolicy();
            SignaturePolicy resolvedPolicy = (SignaturePolicy)policy;
            if (!context.makeDynamicPolicyCallback()) {
                WSSPolicy keyBinding = (WSSPolicy)((SignaturePolicy)policy).getKeyBinding();
                if (PolicyTypeUtil.x509CertificateBinding(keyBinding)) {
                    try {
                        AuthenticationTokenPolicy.X509CertificateBinding binding = (AuthenticationTokenPolicy.X509CertificateBinding)keyBinding.clone();
                        String certIdentifier = binding.getCertificateIdentifier();
                        if (certIdentifier == null || "".equals(certIdentifier)) {
                            WSSPolicy ckBinding = (WSSPolicy)binding.getKeyBinding();
                            if (ckBinding == null) {
                                ckBinding = (WSSPolicy)binding.newPrivateKeyBinding();
                            }
                            if (context.getSecurityEnvironment().getClass().getName().equals("com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl")) {
                                SignatureKeyCallback.PrivKeyCertRequest request = ((DefaultSecurityEnvironmentImpl)context.getSecurityEnvironment()).getDefaultPrivKeyCertRequest(context.getExtraneousProperties());
                                binding.setX509Certificate(request.getX509Certificate());
                                if (request.getX509Certificate() == null) {
                                    throw new XWSSecurityException("No default X509Certificate was provided");
                                }
                                ((PrivateKeyBinding)ckBinding).setPrivateKey(request.getPrivateKey());
                            } else {
                                X509Certificate cert = context.getSecurityEnvironment().getDefaultCertificate(context.getExtraneousProperties());
                                if (cert == null) {
                                    throw new XWSSecurityException("No default X509Certificate was provided");
                                }
                                binding.setX509Certificate(cert);
                                PrivateKey pk = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
                                ((PrivateKeyBinding)ckBinding).setPrivateKey(pk);
                            }
                        } else if (context.getSecurityEnvironment().getClass().getName().equals("com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl")) {
                            SignatureKeyCallback.AliasPrivKeyCertRequest request = ((DefaultSecurityEnvironmentImpl)context.getSecurityEnvironment()).getAliasPrivKeyCertRequest(certIdentifier);
                            binding.setX509Certificate(request.getX509Certificate());
                            if (request.getX509Certificate() == null) {
                                throw new XWSSecurityException("No X509Certificate was provided");
                            }
                            WSSPolicy ckBinding = (WSSPolicy)binding.getKeyBinding();
                            if (PolicyTypeUtil.symmetricKeyBinding(ckBinding)) {
                                try {
                                    SymmetricKeyBinding sBinding = (SymmetricKeyBinding)ckBinding;
                                    String keyIdentifier = sBinding.getKeyIdentifier();
                                    SecretKey key = context.getSecurityEnvironment().getSecretKey(context.getExtraneousProperties(), keyIdentifier, true);
                                    sBinding.setSecretKey(key);
                                }
                                catch (Exception e) {
                                    log.log(Level.SEVERE, "WSS1414.error.extracting.symmetrickey", new Object[]{e.getMessage()});
                                    throw new XWSSecurityException(e);
                                }
                            }
                            if (PolicyTypeUtil.privateKeyBinding(ckBinding)) {
                                ((PrivateKeyBinding)ckBinding).setPrivateKey(request.getPrivateKey());
                            } else {
                                if (ckBinding != null) {
                                    log.log(Level.SEVERE, "WSS1416.unsupported.keybinding");
                                    throw new XWSSecurityException("Unsupported KeyBinding for X509CertificateBinding");
                                }
                                ((PrivateKeyBinding)binding.newPrivateKeyBinding()).setPrivateKey(request.getPrivateKey());
                            }
                        } else {
                            X509Certificate cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), certIdentifier, true);
                            binding.setX509Certificate(cert);
                            WSSPolicy ckBinding = (WSSPolicy)binding.getKeyBinding();
                            PrivateKey key = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), certIdentifier);
                            if (PolicyTypeUtil.privateKeyBinding(ckBinding)) {
                                ((PrivateKeyBinding)ckBinding).setPrivateKey(key);
                            } else {
                                if (ckBinding != null) {
                                    log.log(Level.SEVERE, "WSS1416.unsupported.keybinding");
                                    throw new XWSSecurityException("Unsupported KeyBinding for X509CertificateBinding");
                                }
                                ((PrivateKeyBinding)binding.newPrivateKeyBinding()).setPrivateKey(key);
                            }
                        }
                        context.setX509CertificateBinding(binding);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "WSS1417.exception.processing.signature", new Object[]{e.getMessage()});
                        throw new XWSSecurityException(e);
                    }
                }
                if (!PolicyTypeUtil.samlTokenPolicy(keyBinding)) {
                    log.log(Level.SEVERE, "WSS1419.unsupported.keybinding.signature");
                    throw new XWSSecurityException("Unsupported KeyBinding for SignaturePolicy");
                }
                keyBinding = (WSSPolicy)((SignaturePolicy)policy).getKeyBinding();
                AuthenticationTokenPolicy.SAMLAssertionBinding binding = (AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding;
                binding.isReadOnly(true);
                DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                dynamicContext.inBoundMessage(false);
                AuthenticationTokenPolicy.SAMLAssertionBinding resolvedSAMLBinding = context.getSecurityEnvironment().populateSAMLPolicy(context.getExtraneousProperties(), binding, dynamicContext);
                if (resolvedSAMLBinding.getAssertion() == null && resolvedSAMLBinding.getAuthorityBinding() == null) {
                    log.log(Level.SEVERE, "WSS1418.saml.info.notset");
                    throw new XWSSecurityException("None of SAML Assertion, SAML AuthorityBinding information was set into  the Policy by the CallbackHandler");
                }
                policy.setKeyBinding(resolvedSAMLBinding);
                resolvedPolicy = (SignaturePolicy)policy;
            } else {
                ((SignaturePolicy)policy).isReadOnly(true);
                try {
                    DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                    dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                    dynamicContext.inBoundMessage(false);
                    DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(policy, dynamicContext);
                    ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                    HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
                    resolvedPolicy = (SignaturePolicy)dynamicCallback.getSecurityPolicy();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "WSS1420.dynamic.policy.signature", new Object[]{e.getMessage()});
                    throw new XWSSecurityException(e);
                }
            }
            context.setSecurityPolicy(resolvedPolicy);
            SignatureProcessor.sign(context);
            return;
        }
        if (context.makeDynamicPolicyCallback()) {
            WSSPolicy policy = (WSSPolicy)context.getSecurityPolicy();
            SignaturePolicy resolvedPolicy = null;
            ((SignaturePolicy)policy).isReadOnly(true);
            try {
                DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                dynamicContext.inBoundMessage(true);
                DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(policy, dynamicContext);
                ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
                resolvedPolicy = (SignaturePolicy)dynamicCallback.getSecurityPolicy();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS1420.dynamic.policy.signature", new Object[]{e.getMessage()});
                throw new XWSSecurityException(e);
            }
            context.setSecurityPolicy(resolvedPolicy);
        }
        SignatureProcessor.verify(context);
    }
}

