/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.util.logging;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogAPI {
    private static StackContextManager contextMgr = new StackContextManager();

    public static void init(InputStream input) throws IOException {
        if (Boolean.getBoolean("LogAPI.locked")) {
            return;
        }
        try {
            LogManager.getLogManager().readConfiguration(input);
            LogAPI.logFiner("Logging system initiated");
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Logger getLoggerForClass(String className) {
        return Logger.getLogger(className);
    }

    public static boolean isLoggable(Level level) {
        Logger logger = LogAPI.getLoggerForClass(LogAPI.loggingClass());
        return logger.isLoggable(level);
    }

    public static void logSevere(Throwable tw) {
        String className = LogAPI.loggingClass();
        Logger logger = LogAPI.getLoggerForClass(className);
        logger.logp(Level.SEVERE, className, LogAPI.loggingMethod(), "", tw);
    }

    public static void logSevere(String message) {
        String className = LogAPI.loggingClass();
        Logger logger = LogAPI.getLoggerForClass(className);
        logger.logp(Level.SEVERE, className, LogAPI.loggingMethod(), message);
    }

    public static void logSevere(String message, Object arg) {
        String className = LogAPI.loggingClass();
        Logger logger = LogAPI.getLoggerForClass(className);
        logger.logp(Level.SEVERE, className, LogAPI.loggingMethod(), message, arg);
    }

    public static void logSevere(String message, Object[] args) {
        String className = LogAPI.loggingClass();
        Logger logger = LogAPI.getLoggerForClass(className);
        logger.logp(Level.SEVERE, className, LogAPI.loggingMethod(), message, args);
    }

    public static void logSevere(String message, Throwable thrown) {
        String className = LogAPI.loggingClass();
        Logger logger = LogAPI.getLoggerForClass(className);
        logger.logp(Level.SEVERE, className, LogAPI.loggingMethod(), message, thrown);
    }

    public static void logWarning(Throwable arg) {
        String className = LogAPI.loggingClass();
        Logger logger = LogAPI.getLoggerForClass(className);
        logger.logp(Level.WARNING, className, LogAPI.loggingMethod(), "", arg);
    }

    public static void logWarning(String message) {
        LogAPI.log(message, Level.WARNING);
    }

    public static void logWarning(String message, Object arg) {
        LogAPI.log(message, arg, Level.WARNING);
    }

    public static void logWarning(String message, Object[] args) {
        LogAPI.log(message, args, Level.WARNING);
    }

    public static void logInfo(String message) {
        LogAPI.log(message, Level.INFO);
    }

    public static void logInfo(String message, Object arg) {
        LogAPI.log(message, arg, Level.INFO);
    }

    public static void logInfo(String message, Object[] args) {
        LogAPI.log(message, args, Level.INFO);
    }

    public static void logFine(String message) {
        LogAPI.log(message, Level.FINE);
    }

    public static void logFine(String message, Object arg) {
        LogAPI.log(message, arg, Level.FINE);
    }

    public static void logFine(String message, Object[] args) {
        LogAPI.log(message, args, Level.FINE);
    }

    public static void logFiner(String message) {
        LogAPI.log(message, Level.FINER);
    }

    public static void logFiner(String message, Object arg) {
        LogAPI.log(message, arg, Level.FINER);
    }

    public static void logFiner(String message, Object[] args) {
        LogAPI.log(message, args, Level.FINER);
    }

    public static void logFinest(String message) {
        LogAPI.log(message, Level.FINEST);
    }

    public static void logFinest(String message, Object arg) {
        LogAPI.log(message, arg, Level.FINEST);
    }

    public static void logFinest(String message, Object[] args) {
        LogAPI.log(message, args, Level.FINEST);
    }

    public static void log(String message, Level level) {
        String className = LogAPI.loggingClass();
        Logger logger = LogAPI.getLoggerForClass(className);
        if (logger.isLoggable(level)) {
            logger.logp(level, className, LogAPI.loggingMethod(), message);
        }
    }

    public static void log(String message, Object arg, Level level) {
        String className = LogAPI.loggingClass();
        Logger logger = LogAPI.getLoggerForClass(className);
        if (logger.isLoggable(level)) {
            logger.logp(level, className, LogAPI.loggingMethod(), message, arg);
        }
    }

    public static void log(String message, Object[] args, Level level) {
        String className = LogAPI.loggingClass();
        Logger logger = LogAPI.getLoggerForClass(className);
        if (logger.isLoggable(level)) {
            logger.logp(level, className, LogAPI.loggingMethod(), message, args);
        }
    }

    private static String loggingClass() {
        int i;
        Class<?>[] stack = contextMgr.getClassContext();
        for (i = 1; i < stack.length && stack[i] == LogAPI.class; ++i) {
        }
        return i < stack.length ? stack[i].getName() : null;
    }

    private static String loggingMethod() {
        int i;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (i = 0; i < stack.length && stack[i].getClassName() == Thread.class.getName(); ++i) {
        }
        while (i < stack.length && stack[i].getClassName() == LogAPI.class.getName()) {
            ++i;
        }
        return i < stack.length ? stack[i].getMethodName() : null;
    }

    private static class StackContextManager
    extends SecurityManager {
        private StackContextManager() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

