/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.util;

import asjava.uniclientlibs.UniTokens;

public class UniSeps {
    public static final char sepMinus1 = UniTokens.IM_CHAR.charValue();
    public static final char sep0 = UniTokens.FM_CHAR.charValue();
    public static final char sep1 = UniTokens.VM_CHAR.charValue();
    public static final char sep2 = UniTokens.SVM_CHAR.charValue();
    public static final char sep3 = UniTokens.TM_CHAR.charValue();
    public static final char sep4 = '\u00fa';
    public static final char sep5 = '\u00f9';
    public static final char sep6 = '\u00f8';
    public static final String CUSTOM_SEPARATOR = new Character('\u0007').toString();

    public static final char get(int rank) {
        switch (rank) {
            case -1: {
                return sepMinus1;
            }
            case 0: {
                return sep0;
            }
            case 1: {
                return sep1;
            }
            case 2: {
                return sep2;
            }
            case 3: {
                return sep3;
            }
            case 4: {
                return '\u00fa';
            }
            case 5: {
                return '\u00f9';
            }
            case 6: {
                return '\u00f8';
            }
        }
        throw new IllegalArgumentException("Invalid separator rank: " + rank);
    }

    public static final String raise(String dynArray, int rank) {
        UniSeps.checkNonNegativeRank(rank);
        if (dynArray == null) {
            return null;
        }
        char raisedSep0 = UniSeps.getRaisedSeparator(0, rank);
        char raisedSep1 = UniSeps.getRaisedSeparator(1, rank);
        char raisedSep2 = UniSeps.getRaisedSeparator(2, rank);
        char raisedSep3 = UniSeps.getRaisedSeparator(3, rank);
        char raisedSep4 = UniSeps.getRaisedSeparator(4, rank);
        char raisedSep5 = UniSeps.getRaisedSeparator(5, rank);
        char raisedSep6 = UniSeps.getRaisedSeparator(6, rank);
        StringBuilder sb = new StringBuilder(dynArray);
        int length = sb.length();
        for (int i = 0; i < length; ++i) {
            char c = sb.charAt(i);
            if (c == sep0) {
                sb.setCharAt(i, raisedSep0);
                continue;
            }
            if (c == sep1) {
                sb.setCharAt(i, raisedSep1);
                continue;
            }
            if (c == sep2) {
                sb.setCharAt(i, raisedSep2);
                continue;
            }
            if (c == sep3) {
                sb.setCharAt(i, raisedSep3);
                continue;
            }
            if (c == '\u00fa') {
                sb.setCharAt(i, raisedSep4);
                continue;
            }
            if (c == '\u00f9') {
                sb.setCharAt(i, raisedSep5);
                continue;
            }
            if (c != '\u00f8') continue;
            sb.setCharAt(i, raisedSep6);
        }
        return sb.toString();
    }

    static final char getRaisedSeparator(int sepRank, int raiseBy) {
        int raisedSepRank = sepRank - raiseBy;
        if (raisedSepRank < -1) {
            raisedSepRank = -1;
        }
        if (raisedSepRank > 6) {
            raisedSepRank = 6;
        }
        return UniSeps.get(raisedSepRank);
    }

    public static final String lower(String dynArray, int rank) {
        UniSeps.checkNonNegativeRank(rank);
        if (dynArray == null) {
            return null;
        }
        rank = -rank;
        char loweredSepMinusOne = UniSeps.getRaisedSeparator(-1, rank);
        char loweredSep0 = UniSeps.getRaisedSeparator(0, rank);
        char loweredSep1 = UniSeps.getRaisedSeparator(1, rank);
        char loweredSep2 = UniSeps.getRaisedSeparator(2, rank);
        char loweredSep3 = UniSeps.getRaisedSeparator(3, rank);
        char loweredSep4 = UniSeps.getRaisedSeparator(4, rank);
        char loweredSep5 = UniSeps.getRaisedSeparator(5, rank);
        StringBuilder sb = new StringBuilder(dynArray);
        int length = sb.length();
        for (int i = 0; i < length; ++i) {
            char c = sb.charAt(i);
            if (c == '\u00f9') {
                sb.setCharAt(i, loweredSep5);
                continue;
            }
            if (c == '\u00fa') {
                sb.setCharAt(i, loweredSep4);
                continue;
            }
            if (c == sep3) {
                sb.setCharAt(i, loweredSep3);
                continue;
            }
            if (c == sep2) {
                sb.setCharAt(i, loweredSep2);
                continue;
            }
            if (c == sep1) {
                sb.setCharAt(i, loweredSep1);
                continue;
            }
            if (c == sep0) {
                sb.setCharAt(i, loweredSep0);
                continue;
            }
            if (c != sepMinus1) continue;
            sb.setCharAt(i, loweredSepMinusOne);
        }
        return sb.toString();
    }

    private static final void checkNonNegativeRank(int rank) {
        if (rank < 0) {
            throw new IllegalArgumentException("Rank must be a non-negative number");
        }
    }
}

