/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.util;

import com.selima.framework.util.ArrayUtil;
import com.selima.framework.util.Util;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import junit.framework.Assert;

public class TestUtil {
    public static final void assertErrorMessageContains(Throwable e, String s) {
        if (e == null) {
            Assert.fail((String)"Null passed.");
        }
        Assert.assertTrue((String)("Message: " + e.getMessage()), (e.getMessage() != null && e.getMessage().indexOf(s) >= 0 ? 1 : 0) != 0);
    }

    public static final void assertErrorMessageNotContains(Throwable e, String s) {
        if (e == null) {
            return;
        }
        Assert.assertFalse((e.getMessage() != null && e.getMessage().indexOf(s) >= 0 ? 1 : 0) != 0);
    }

    public static final void assertErrorMessageContains(String comment, Throwable e, String s) {
        if (e == null) {
            Assert.fail((String)"Null passed.");
        }
        Assert.assertTrue((String)("Comment: " + comment + " Message: " + e.getMessage()), (e.getMessage() != null && e.getMessage().indexOf(s) >= 0 ? 1 : 0) != 0);
    }

    public static final void assertContains(String container, String containee) {
        Assert.assertTrue((String)container, (container != null && container.indexOf(containee) >= 0 ? 1 : 0) != 0);
    }

    public static final void assertContains(String message, String container, String containee) {
        Assert.assertTrue((String)(message + ": " + container), (container != null && container.indexOf(containee) >= 0 ? 1 : 0) != 0);
    }

    public static final void assertEmpty(Object s) {
        Assert.assertTrue((String)(s == null ? "null" : s.toString()), (boolean)Util.isEmpty(s));
    }

    public static final void assertNotEmpty(String s) {
        Assert.assertFalse((boolean)Util.isEmpty(s));
    }

    public static final void writeToFile(File file, String content) throws IOException {
        try (FileWriter writer = null;){
            writer = new FileWriter(file);
            writer.write(content);
        }
    }

    public static final String generateRandomString(int length) {
        StringBuffer buff = new StringBuffer();
        while (buff.length() < length) {
            buff.append(Math.random());
        }
        return buff.toString().substring(0, length);
    }

    public static final void assertEquals(byte[] expected, byte[] actual) {
        TestUtil.assertEquals(ArrayUtil.toString(actual), expected, actual);
    }

    public static final void assertEquals(String message, byte[] expected, byte[] actual) {
        Assert.assertTrue((String)message, (boolean)Arrays.equals(expected, actual));
    }

    public static final void assertEquals(int[] expected, int[] actual) {
        TestUtil.assertEquals(ArrayUtil.toString(actual), expected, actual);
    }

    public static final void assertEquals(String message, int[] expected, int[] actual) {
        Assert.assertTrue((String)message, (boolean)Arrays.equals(expected, actual));
    }

    public static final void assertEquals(Object[] expected, Object[] actual) {
        TestUtil.assertEquals("", expected, actual);
    }

    public static final <T extends Comparable<?>> void assertEqualsSorted(T[] expected, T[] actual) {
        expected = (Comparable[])expected.clone();
        actual = (Comparable[])actual.clone();
        Arrays.sort(expected);
        Arrays.sort(actual);
        TestUtil.assertEquals("", expected, actual);
    }

    public static final void assertEquals(String message, Object[] expected, Object[] actual) {
        Assert.assertTrue((String)(message + " Expected: " + ArrayUtil.toString(expected) + " Actual: " + ArrayUtil.toString(actual)), (boolean)Arrays.equals(expected, actual));
    }

    public static final void assertInstanceOf(Object o, Class c) {
        if (!c.isInstance(o)) {
            Assert.fail((String)(o == null ? "null" : o.getClass().getName()));
        }
    }

    public static final void assertNotInstanceOf(Object o, Class c) {
        if (c.isInstance(o)) {
            Assert.fail((String)o.getClass().getName());
        }
    }

    public static final void assertColorEquals(Color expected, Color actual) {
        Assert.assertEquals((int)expected.getRGB(), (int)actual.getRGB());
    }

    public static final void assertDateEquals(int year, int month, int day, Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String expected = day + "/" + month + "/" + year;
        String actual = calendar.get(5) + "/" + (calendar.get(2) + 1) + "/" + calendar.get(1);
        Assert.assertEquals((String)expected, (String)actual);
    }

    public static final Date createDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day);
        Date date = calendar.getTime();
        return Util.normalizeDate(date);
    }

    public static final File createTempDir() throws IOException {
        return TestUtil.createTempDir(null);
    }

    public static final File createTempDir(String name) throws IOException {
        File tempFile = File.createTempFile("foo", "bar");
        File tempDir = Util.getChild(tempFile.getParent(), name == null ? tempFile.getName() + "_dir" : name);
        tempFile.delete();
        Util.deleteRecursively(tempDir);
        tempDir.mkdir();
        return tempDir;
    }
}

