/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.util;

import com.selima.framework.util.ArrayUtil;
import com.selima.framework.util.Util;
import java.util.Arrays;

public class Path {
    private Integer[] path;

    public Path(Integer ... path) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.path = path;
    }

    public Path append(Integer pathElement) {
        return new Path(ArrayUtil.append(this.path, pathElement));
    }

    public Path prepend(Integer pathElement) {
        return new Path(ArrayUtil.prepend(pathElement, this.path));
    }

    public Path removeFirst() {
        return new Path(ArrayUtil.remove(this.path, 0));
    }

    public Path removeFirst(int count) {
        Path result = this;
        for (int i = 0; i < count; ++i) {
            result = result.removeFirst();
        }
        return result;
    }

    public Path removeLast() {
        return new Path(ArrayUtil.remove(this.path, this.path.length - 1));
    }

    public Integer[] getPathElements() {
        return this.path;
    }

    public String toString() {
        return ArrayUtil.toString((Object[])this.path, "[", "]", "/");
    }

    public boolean isEmpty() {
        return this.path.length == 0;
    }

    public boolean equals(Object other) {
        return other != null && other.getClass().equals(this.getClass()) && Arrays.equals((Object[])this.getPathElements(), (Object[])((Path)other).getPathElements());
    }

    public boolean isEquivalent(Path other) {
        return this.equals(other) || this.isEmpty() && other == null;
    }

    public boolean startsWith(Path other) {
        if (this.isEquivalent(other)) {
            return true;
        }
        if (other == null) {
            return true;
        }
        Integer[] otherPathElements = other.getPathElements();
        if (otherPathElements.length >= this.path.length) {
            return false;
        }
        for (int i = 0; i < otherPathElements.length; ++i) {
            if (Util.equals(otherPathElements[i], this.path[i])) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.path.length;
    }
}

