/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.util;

public class Interval {
    private int from;
    private int to;

    public Interval(int from, int to) {
        this.from = from;
        this.to = to;
        if (from > to) {
            throw new IllegalArgumentException(this.toString());
        }
        if (from < 0) {
            throw new IllegalArgumentException(this.toString());
        }
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public boolean equals(Object other) {
        return other instanceof Interval && ((Interval)other).from == this.from && ((Interval)other).to == this.to;
    }

    public String toString() {
        return "Interval(" + this.from + ", " + this.to + ")";
    }

    public static Interval enhanceIntervals(Interval ... intervals) {
        int from = intervals[0].getFrom();
        int to = intervals[0].getTo();
        for (int i = 1; i < intervals.length; ++i) {
            from = Math.min(from, intervals[i].getFrom());
            to = Math.max(to, intervals[i].getTo());
        }
        return new Interval(from, to);
    }

    public int getSize() {
        return this.to - this.from + 1;
    }

    public boolean contains(int element) {
        return element >= this.from && element <= this.to;
    }

    public boolean contains(Interval interval) {
        return interval.from >= this.from && interval.to <= this.to;
    }

    public boolean intersects(Interval other) {
        return this.from <= other.to && this.to >= other.from;
    }

    public Interval append(int length) {
        return new Interval(this.from, this.to + length);
    }
}

