/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.util;

import com.selima.framework.util.logging.LogAPI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.StringTokenizer;

public class DynamicURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    static boolean installed;

    public static void registerURLHandler(Class<? extends URLStreamHandler> type) {
        DynamicURLStreamHandlerFactory.install();
        String handlerSearchPath = System.getProperty("java.protocol.handler.pkgs");
        String handlerClassName = type.getName();
        String handlerPackageName = handlerClassName.substring(0, handlerClassName.lastIndexOf(46, handlerClassName.lastIndexOf(46) - 1));
        handlerSearchPath = handlerSearchPath != null ? handlerSearchPath + "|" + handlerPackageName : handlerPackageName;
        System.setProperty("java.protocol.handler.pkgs", handlerSearchPath);
    }

    public static synchronized void install() {
        if (!installed) {
            try {
                installed = true;
                URL.setURLStreamHandlerFactory(new DynamicURLStreamHandlerFactory());
            }
            catch (Error error) {
                LogAPI.logWarning(error);
            }
        }
    }

    private DynamicURLStreamHandlerFactory() {
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        String packagePrefixList = System.getProperty("java.protocol.handler.pkgs", "");
        StringTokenizer packagePrefixIter = new StringTokenizer(packagePrefixList, "|");
        while (packagePrefixIter.hasMoreTokens()) {
            String packagePrefix = packagePrefixIter.nextToken().trim();
            try {
                Class<?> cls;
                block5: {
                    String clsName = packagePrefix + "." + protocol + ".Handler";
                    cls = null;
                    try {
                        cls = Class.forName(clsName);
                    }
                    catch (ClassNotFoundException e) {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        if (cl == null) break block5;
                        cls = cl.loadClass(clsName);
                    }
                }
                if (cls == null) continue;
                return (URLStreamHandler)cls.newInstance();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

